/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.instruct.ApplyImports;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLWithParam;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class XSLApplyImports
extends StyleElement {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            this.checkUnknownAttribute(nc);
            ++a;
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-imports", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + child.getDisplayName() + " is not allowed within xsl:apply-imports", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        ApplyImports inst = new ApplyImports();
        inst.setActualParameters(this.getWithParamInstructions(exec, false, inst), this.getWithParamInstructions(exec, true, inst));
        return inst;
    }
}

