/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.util.Collections;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Container;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.functions.ConstructorFunctionLibrary;
import net2.sf.saxon.functions.FunctionLibrary;
import net2.sf.saxon.functions.FunctionLibraryList;
import net2.sf.saxon.functions.SystemFunctionLibrary;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.QNameException;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.style.StyleNodeFactory;
import net2.sf.saxon.style.XSLTStaticContext;
import net2.sf.saxon.sxpath.AbstractStaticContext;
import net2.sf.saxon.trans.DecimalFormatManager;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;

public class UseWhenStaticContext
extends AbstractStaticContext
implements XSLTStaticContext,
Container {
    public NamespaceResolver namespaceContext;
    public FunctionLibrary functionLibrary;
    public StyleNodeFactory nodeFactory;

    public UseWhenStaticContext(Configuration config, NamespaceResolver namespaceContext) {
        this.setConfiguration(config);
        this.namespaceContext = namespaceContext;
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(5));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(lib);
        this.functionLibrary = lib;
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        XPathException err = new XPathException(s);
        err.setLocator(locator);
        try {
            this.getConfiguration().getErrorListener().warning(err);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public String getSystemId() {
        return this.getBaseURI();
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.namespaceContext.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
            err.setErrorCode("XTDE0290");
            throw err;
        }
        return uri;
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        XPathException err = new XPathException("Variables cannot be used in a use-when expression");
        err.setErrorCode("XPST0008");
        err.setIsStaticError(true);
        throw err;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public StringCollator getCollation(String name) {
        return null;
    }

    @Override
    public String getDefaultCollationName() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return false;
    }

    @Override
    public Set getImportedSchemaNamespaces() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        Configuration config = this.getConfiguration();
        if (type.getFingerprint() == 565) {
            return config.getXsdVersion() == Configuration.XSD11;
        }
        return this.getExecutable().isSchemaAware() || type.isAllowedInBasicXSLT();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceContext;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return null;
    }

    public Boolean isAllowTypedNodes() {
        return Boolean.FALSE;
    }

    @Override
    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            if (this.nodeFactory == null) {
                Configuration config = this.getConfiguration();
                this.nodeFactory = config.getStyleNodeFactory();
            }
            return this.nodeFactory.isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }
}

