/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import javax.xml.transform.TransformerException;
import net2.sf.saxon.PreparedStylesheet;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.AttributeSet;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.FixedAttribute;
import net2.sf.saxon.instruct.FixedElement;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.instruct.TraceExpression;
import net2.sf.saxon.instruct.UseAttributeSets;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StyleNodeFactory;
import net2.sf.saxon.style.XSLStylesheet;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.tree.DocumentImpl;
import net2.sf.saxon.tree.TreeBuilder;
import net2.sf.saxon.type.SchemaType;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        int num = this.getAttributeList().getLength();
        if (num == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new int[num];
            this.attributeValues = new Expression[num];
            this.numberOfAttributes = 0;
            int i = 0;
            while (i < num) {
                int anameCode = this.attributeList.getNameCode(i);
                short attURIcode = namePool.getURICode(anameCode);
                if (attURIcode == 2) {
                    int fp = anameCode & 0xFFFFF;
                    if (fp != 233 && fp != 228 && fp != 230 && fp != 229 && fp != 236 && fp != 237 && fp != 232 && fp != 234 && fp != 235) {
                        if (fp == 231) {
                            String inheritAtt = this.attributeList.getValue(i);
                            if (inheritAtt.equals("yes")) {
                                this.inheritNamespaces = true;
                            } else if (inheritAtt.equals("no")) {
                                this.inheritNamespaces = false;
                            } else {
                                this.compileError("The xsl:inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
                            }
                        } else {
                            this.compileError("Unknown XSL attribute " + namePool.getDisplayName(anameCode), "XTSE0805");
                        }
                    }
                } else {
                    Expression exp;
                    this.attributeNames[this.numberOfAttributes] = anameCode;
                    this.attributeValues[this.numberOfAttributes] = exp = this.makeAttributeValueTemplate(this.attributeList.getValue(i));
                    ++this.numberOfAttributes;
                }
                ++i;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                int[] attributeNames2 = new int[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, attributeNames2, 0, this.numberOfAttributes);
                this.attributeNames = attributeNames2;
                Expression[] attributeValues2 = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, attributeValues2, 0, this.numberOfAttributes);
                this.attributeValues = attributeValues2;
            }
        }
    }

    @Override
    public void validate() throws XPathException {
        this.toplevel = this.getParent() instanceof XSLStylesheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short elementURICode = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (elementURICode == 0) {
                this.compileError("Top level elements must have a non-null namespace URI", "XTSE0130");
            }
        } else {
            String validate;
            String useAttSets;
            XSLStylesheet sheet;
            this.namespaceCodes = this.getInScopeNamespaceCodes();
            String defaultNamespace = this.getURIForPrefix("", true);
            if (defaultNamespace.length() == 0) {
                int[] n2 = new int[this.namespaceCodes.length + 1];
                System.arraycopy(this.namespaceCodes, 0, n2, 0, this.namespaceCodes.length);
                n2[this.namespaceCodes.length] = 0;
                this.namespaceCodes = n2;
            }
            if ((sheet = this.getPrincipalStylesheet()).hasNamespaceAliases()) {
                int i = 0;
                while (i < this.namespaceCodes.length) {
                    short scode = (short)(this.namespaceCodes[i] & 0xFFFF);
                    int ncode = sheet.getNamespaceAlias(scode);
                    if (ncode != -1 && (ncode & 0xFFFF) != scode) {
                        this.namespaceCodes[i] = ncode;
                    }
                    ++i;
                }
                int ercode = sheet.getNamespaceAlias(elementURICode);
                if ((ercode & 0xFFFF) != elementURICode) {
                    this.resultNameCode = namePool.allocate(namePool.getPrefixFromNamespaceCode(ercode), namePool.getURIFromNamespaceCode(ercode), this.getLocalPart());
                }
            }
            if ((useAttSets = this.getAttributeValue(233)) != null) {
                this.attributeSets = this.getAttributeSets(useAttSets, null);
            }
            this.validation = this.getContainingStylesheet().getDefaultValidation();
            String type = this.getAttributeValue(232);
            if (type != null) {
                if (!this.getExecutable().isSchemaAware()) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
                }
                this.schemaType = this.getSchemaType(type);
                this.validation = 8;
            }
            if ((validate = this.getAttributeValue(235)) != null) {
                this.validation = Validation.getCode(validate);
                if (this.validation != 4 && !this.getExecutable().isSchemaAware()) {
                    this.validation = 4;
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                }
                if (this.validation == -1) {
                    this.compileError("Invalid value for xsl:validation. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                }
                if (this.schemaType != null) {
                    this.compileError("The attributes xsl:type and xsl:validation are mutually exclusive", "XTSE1505");
                }
            }
            if (this.numberOfAttributes > 0) {
                int i = 0;
                while (i < this.numberOfAttributes) {
                    int newNSCode;
                    int anameCode;
                    int alias = anameCode = this.attributeNames[i];
                    short attURIcode = namePool.getURICode(anameCode);
                    if (attURIcode != 0 && ((newNSCode = sheet.getNamespaceAlias(attURIcode)) & 0xFFFF) != attURIcode) {
                        alias = namePool.allocate(namePool.getPrefixFromNamespaceCode(newNSCode), namePool.getURIFromNamespaceCode(newNSCode), this.attributeList.getLocalName(i));
                    }
                    this.attributeNames[i] = alias;
                    this.attributeValues[i] = this.typeCheck(namePool.getDisplayName(alias), this.attributeValues[i]);
                    ++i;
                }
            }
            int numberExcluded = 0;
            int n = 0;
            while (n < this.namespaceCodes.length) {
                short uricode = (short)(this.namespaceCodes[n] & 0xFFFF);
                if (this.isExcludedNamespace(uricode) && !sheet.isAliasResultNamespace(uricode)) {
                    this.namespaceCodes[n] = -1;
                    ++numberExcluded;
                }
                ++n;
            }
            int count = this.namespaceCodes.length - numberExcluded;
            if (count == 0) {
                this.namespaceCodes = null;
            } else {
                int[] newNamespaceCodes = new int[count];
                count = 0;
                int i = 0;
                while (i < this.namespaceCodes.length) {
                    if (this.namespaceCodes[i] != -1) {
                        newNamespaceCodes[count++] = this.namespaceCodes[i];
                    }
                    ++i;
                }
                this.namespaceCodes = newNamespaceCodes;
            }
        }
    }

    @Override
    protected void validateChildren() throws XPathException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        if (this.toplevel) {
            return null;
        }
        FixedElement inst = new FixedElement(this.resultNameCode, this.namespaceCodes, this.inheritNamespaces, this.schemaType, this.validation);
        inst.setBaseURI(this.getBaseURI());
        Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (this.numberOfAttributes > 0) {
            int i = this.attributeNames.length - 1;
            while (i >= 0) {
                FixedAttribute att = new FixedAttribute(this.attributeNames[i], 4, null, 631);
                try {
                    att.setSelect(this.attributeValues[i], exec.getConfiguration());
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
                att.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                Instruction exp = att;
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceExpression trace = new TraceExpression(exp);
                    trace.setLineNumber(this.getLineNumber());
                    trace.setColumnNumber(-1);
                    trace.setSystemId(this.getSystemId());
                    trace.setNamespaceResolver(this.getNamespaceResolver());
                    trace.setConstructType(2007);
                    trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    trace.setObjectName(new StructuredQName(this.getNamePool(), this.attributeNames[i]));
                    exp = trace;
                }
                if (content == null) {
                    content = exp;
                } else {
                    content = Block.makeBlock(exp, content);
                    content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                }
                --i;
            }
        }
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        return inst;
    }

    public DocumentImpl makeStylesheet(PreparedStylesheet pss, StyleNodeFactory nodeFactory) throws XPathException {
        NamePool pool = this.getNamePool();
        String xslPrefix = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (xslPrefix == null) {
            String message = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            XPathException err = new XPathException(message);
            err.setLocator(this);
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            try {
                pss.reportError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw err;
        }
        String version = this.getAttributeValue(236);
        if (version == null) {
            XPathException err = new XPathException("Simplified stylesheet: xsl:version attribute is missing");
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            err.setLocator(this);
            try {
                pss.reportError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw err;
        }
        try {
            DocumentImpl oldRoot = (DocumentImpl)this.getDocumentRoot();
            TreeBuilder builder = new TreeBuilder();
            builder.setPipelineConfiguration(pss.getConfiguration().makePipelineConfiguration());
            builder.setNodeFactory(nodeFactory);
            builder.setSystemId(this.getSystemId());
            builder.open();
            builder.startDocument(0);
            int st = 180;
            builder.startElement(st, 630, 0, 0);
            builder.namespace(2, 0);
            builder.attribute(pool.allocate("", "", "version"), 631, version, 0, 0);
            builder.startContent();
            int te = 181;
            builder.startElement(te, 630, 0, 0);
            builder.attribute(pool.allocate("", "", "match"), 631, "/", 0, 0);
            builder.startContent();
            builder.graftElement(this);
            builder.endElement();
            builder.endElement();
            builder.endDocument();
            builder.close();
            DocumentImpl newRoot = (DocumentImpl)builder.getCurrentRoot();
            newRoot.graftLocationMap(oldRoot);
            return newRoot;
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    @Override
    public int getConstructType() {
        return 2006;
    }

    public int getObjectNameCode() {
        return this.resultNameCode;
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

