/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net2.sf.saxon.expr.AtomicSequenceConverter;
import net2.sf.saxon.expr.Atomizer;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionParser;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FirstItemExpression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.functions.Concat;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.instruct.SimpleContentConstructor;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.StringValue;

public abstract class AttributeValueTemplate {
    private AttributeValueTemplate() {
    }

    public static Expression make(String avt, int lineNumber, StaticContext env) throws XPathException {
        ArrayList<Expression> components = new ArrayList<Expression>(5);
        int len = avt.length();
        int last = 0;
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        while (last < len) {
            int i0 = avt.indexOf("{", last);
            int i1 = avt.indexOf("{{", last);
            int i8 = avt.indexOf("}", last);
            int i9 = avt.indexOf("}}", last);
            if (!(i0 >= 0 && len >= i0 || i8 >= 0 && len >= i8)) {
                AttributeValueTemplate.addStringComponent(components, avt, last, len);
                break;
            }
            if (i8 >= 0 && (i0 < 0 || i8 < i0)) {
                if (i8 != i9) {
                    XPathException err = new XPathException("Closing curly brace in attribute value template \"" + avt.substring(0, len) + "\" must be doubled");
                    err.setErrorCode("XTSE0370");
                    err.setIsStaticError(true);
                    throw err;
                }
                AttributeValueTemplate.addStringComponent(components, avt, last, i8 + 1);
                last = i8 + 2;
                continue;
            }
            if (i1 >= 0 && i1 == i0) {
                AttributeValueTemplate.addStringComponent(components, avt, last, i1 + 1);
                last = i1 + 2;
                continue;
            }
            if (i0 >= 0) {
                if (i0 > last) {
                    AttributeValueTemplate.addStringComponent(components, avt, last, i0);
                }
                ExpressionParser parser = new ExpressionParser();
                Expression exp = parser.parse(avt, i0 + 1, 215, lineNumber, env);
                exp = visitor.simplify(exp);
                last = parser.getTokenizer().currentTokenStartOffset + 1;
                if (env.isInBackwardsCompatibleMode()) {
                    components.add(AttributeValueTemplate.makeFirstItem(exp, env));
                    continue;
                }
                components.add(visitor.simplify(new SimpleContentConstructor(exp, new StringLiteral(StringValue.SINGLE_SPACE))));
                continue;
            }
            throw new IllegalStateException("Internal error parsing AVT");
        }
        if (components.size() == 0) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        if (components.size() == 1) {
            return visitor.simplify((Expression)components.get(0));
        }
        Expression[] args = new Expression[components.size()];
        components.toArray(args);
        Concat fn = (Concat)SystemFunction.makeSystemFunction("concat", args);
        fn.setLocationId(env.getLocationMap().allocateLocationId(env.getSystemId(), lineNumber));
        return visitor.simplify(fn);
    }

    private static void addStringComponent(List components, String avt, int start, int end) {
        if (start < end) {
            components.add(new StringLiteral(avt.substring(start, end)));
        }
    }

    public static Expression makeFirstItem(Expression exp, StaticContext env) {
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        if (!exp.getItemType(th).isAtomicType()) {
            exp = new Atomizer(exp);
        }
        if (Cardinality.allowsMany(exp.getCardinality())) {
            exp = new FirstItemExpression(exp);
        }
        if (!th.isSubType(exp.getItemType(th), BuiltInAtomicType.STRING)) {
            exp = new AtomicSequenceConverter(exp, BuiltInAtomicType.STRING);
        }
        return exp;
    }
}

