/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.SortedIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Closure;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.ObjectValue;

public class SortedTupleIterator
extends SortedIterator {
    public SortedTupleIterator(XPathContext context, SequenceIterator base, AtomicComparer[] comparators) {
        super(context, base, null, comparators);
        this.setHostLanguage(51);
    }

    @Override
    protected void buildArray() throws XPathException {
        ObjectValue tupleObject;
        int allocated = 100;
        this.nodeKeys = new Object[allocated * this.recordSize];
        this.count = 0;
        while ((tupleObject = (ObjectValue)this.base.next()) != null) {
            ValueRepresentation[] tuple = (ValueRepresentation[])tupleObject.getObject();
            if (this.count == allocated) {
                Object[] nk2 = new Object[(allocated *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, nk2, 0, this.count * this.recordSize);
                this.nodeKeys = nk2;
            }
            int k = this.count * this.recordSize;
            this.nodeKeys[k] = new ObjectValue(tuple[0]);
            int n = 1;
            while (n <= this.comparators.length) {
                ValueRepresentation v = tuple[n];
                if (v instanceof Closure) {
                    v = ((Closure)v).reduce();
                }
                this.nodeKeys[k + n] = v instanceof EmptySequence ? null : v;
                ++n;
            }
            this.nodeKeys[k + this.comparators.length + 1] = new Integer(this.count);
            ++this.count;
        }
    }
}

