/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.GroupIterator;
import net2.sf.saxon.sort.SortKeyEvaluator;
import net2.sf.saxon.sort.SortedIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;

public class SortedGroupIterator
extends SortedIterator
implements GroupIterator {
    private Instruction origin;

    public SortedGroupIterator(XPathContext context, GroupIterator base, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] comparators, Instruction origin) {
        super(context, base, sortKeyEvaluator, comparators);
        this.setHostLanguage(50);
        this.origin = origin;
        this.recordSize += 2;
    }

    @Override
    protected void buildArray() throws XPathException {
        Item item;
        int allocated = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)this.base).getLastPosition() : 100;
        this.nodeKeys = new Object[allocated * this.recordSize];
        this.count = 0;
        XPathContextMajor c2 = this.context.newContext();
        c2.setCurrentIterator(this.base);
        c2.setOrigin(this.origin);
        c2.setCurrentGroupIterator((GroupIterator)this.base);
        while ((item = this.base.next()) != null) {
            if (this.count == allocated) {
                Object[] nk2 = new Object[(allocated *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, nk2, 0, this.count * this.recordSize);
                this.nodeKeys = nk2;
            }
            int k = this.count * this.recordSize;
            this.nodeKeys[k] = item;
            int n = 0;
            while (n < this.comparators.length) {
                this.nodeKeys[k + n + 1] = this.sortKeyEvaluator.evaluateSortKey(n, c2);
                ++n;
            }
            this.nodeKeys[k + this.comparators.length + 1] = new Integer(this.count);
            this.nodeKeys[k + this.comparators.length + 2] = ((GroupIterator)this.base).getCurrentGroupingKey();
            this.nodeKeys[k + this.comparators.length + 3] = ((GroupIterator)this.base).iterateCurrentGroup();
            ++this.count;
        }
    }

    @Override
    public AtomicValue getCurrentGroupingKey() {
        return (AtomicValue)this.nodeKeys[(this.position - 1) * this.recordSize + this.comparators.length + 2];
    }

    @Override
    public SequenceIterator iterateCurrentGroup() throws XPathException {
        SequenceIterator iter = (SequenceIterator)this.nodeKeys[(this.position - 1) * this.recordSize + this.comparators.length + 3];
        return iter.getAnother();
    }
}

