/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.ListIterator;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.AtomicSortComparer;
import net2.sf.saxon.sort.ComparisonKey;
import net2.sf.saxon.sort.GroupIterator;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.AtomicValue;

public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private StringCollator collator;
    private AtomicComparer comparer;
    private ComparisonKey currentComparisonKey;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator population, Expression keyExpression, XPathContext baseContext, StringCollator collator) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.baseContext = baseContext;
        this.runningContext = baseContext.newMinorContext();
        this.runningContext.setCurrentIterator(population);
        this.collator = collator;
        int type = keyExpression.getItemType(baseContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
        this.comparer = AtomicSortComparer.makeSortComparer(collator, type, baseContext);
        this.next = population.next();
        if (this.next != null) {
            this.nextKey = (AtomicValue)keyExpression.evaluateItem(this.runningContext);
        }
    }

    private void advance() throws XPathException {
        Item nextCandidate;
        this.currentMembers = new ArrayList(20);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            AtomicValue candidateKey = (AtomicValue)this.keyExpression.evaluateItem(this.runningContext);
            try {
                if (this.currentComparisonKey.equals(this.comparer.getComparisonKey(candidateKey))) {
                    this.currentMembers.add(nextCandidate);
                    continue;
                }
                this.next = nextCandidate;
                this.nextKey = candidateKey;
                return;
            }
            catch (ClassCastException e) {
                XPathException err = new XPathException("Grouping key values are of non-comparable types (" + Type.displayTypeName(this.currentKey) + " and " + Type.displayTypeName(candidateKey) + ')');
                err.setIsTypeError(true);
                err.setXPathContext(this.runningContext);
                throw err;
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    @Override
    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    @Override
    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Item next() throws XPathException {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey;
        this.currentComparisonKey = this.comparer.getComparisonKey(this.currentKey);
        ++this.position;
        this.advance();
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.population.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population.getAnother(), this.keyExpression, this.baseContext, this.collator);
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

