/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.AtomicSortComparer;
import net2.sf.saxon.sort.ComparisonKey;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.NumericValue;

public class DoubleSortComparer
implements AtomicComparer {
    private static DoubleSortComparer THE_INSTANCE = new DoubleSortComparer();

    public static DoubleSortComparer getInstance() {
        return THE_INSTANCE;
    }

    private DoubleSortComparer() {
    }

    @Override
    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    @Override
    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        NumericValue an = (NumericValue)a;
        NumericValue bn = (NumericValue)b;
        if (an.isNaN()) {
            return bn.isNaN() ? 0 : -1;
        }
        if (bn.isNaN()) {
            return 1;
        }
        return an.compareTo(bn);
    }

    @Override
    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        return this.compareAtomicValues(a, b) == 0;
    }

    @Override
    public ComparisonKey getComparisonKey(AtomicValue a) {
        if (((NumericValue)a).isNaN()) {
            return new ComparisonKey(635, AtomicSortComparer.COLLATION_KEY_NaN);
        }
        return new ComparisonKey(635, a);
    }
}

