/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.GenericSorter;
import net2.sf.saxon.sort.NodeOrderComparer;
import net2.sf.saxon.sort.Sortable;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceExtent;

public final class DocumentOrderIterator
implements SequenceIterator,
Sortable {
    private SequenceIterator iterator;
    private SequenceExtent sequence;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public DocumentOrderIterator(SequenceIterator base, NodeOrderComparer comparer) throws XPathException {
        this.comparer = comparer;
        this.sequence = new SequenceExtent(base);
        if (this.sequence.getLength() > 1) {
            GenericSorter.quickSort(0, this.sequence.getLength(), this);
        }
        this.iterator = this.sequence.iterate();
    }

    private DocumentOrderIterator() {
    }

    @Override
    public int compare(int a, int b) {
        return this.comparer.compare((NodeInfo)this.sequence.itemAt(a), (NodeInfo)this.sequence.itemAt(b));
    }

    @Override
    public void swap(int a, int b) {
        this.sequence.swap(a, b);
    }

    @Override
    public Item next() throws XPathException {
        NodeInfo next;
        do {
            if ((next = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            this.position = -1;
            return null;
        } while (this.current != null && next.isSameNodeInfo(this.current));
        ++this.position;
        this.current = next;
        return this.current;
    }

    @Override
    public int getProperties() {
        return 0;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        DocumentOrderIterator another = new DocumentOrderIterator();
        another.iterator = this.iterator.getAnother();
        return another;
    }
}

