/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import java.util.Iterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PairIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.DocumentSorter;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public class ConditionalSorter
extends Expression {
    private Expression condition;
    private DocumentSorter documentSorter;

    public ConditionalSorter(Expression condition, DocumentSorter sorter) {
        this.condition = condition;
        this.documentSorter = sorter;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public DocumentSorter getDocumentSorter() {
        return this.documentSorter;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.condition = visitor.typeCheck(this.condition, contextItemType);
        Expression sorter = visitor.typeCheck(this.documentSorter, contextItemType);
        if (sorter instanceof DocumentSorter) {
            this.documentSorter = (DocumentSorter)sorter;
            return this;
        }
        return sorter;
    }

    @Override
    public int getCardinality() {
        return this.documentSorter.getCardinality();
    }

    @Override
    protected int computeSpecialProperties() {
        return this.condition.getSpecialProperties() | 0x20000;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.condition, this.documentSorter);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.condition == original) {
            this.condition = replacement;
            found = true;
        }
        if (this.documentSorter == original) {
            this.documentSorter = (DocumentSorter)replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy() {
        return new ConditionalSorter(this.condition.copy(), (DocumentSorter)this.documentSorter.copy());
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("conditionalSort");
        this.condition.explain(out);
        this.documentSorter.explain(out);
        out.endElement();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.documentSorter.getItemType(th);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.condition = this.doPromotion(this, this.condition, offer);
        Expression e = this.doPromotion(this, this.documentSorter, offer);
        if (e instanceof DocumentSorter) {
            return this;
        }
        return e;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        boolean b = this.condition.effectiveBooleanValue(context);
        if (b) {
            return this.documentSorter.iterate(context);
        }
        return this.documentSorter.getBaseExpression().iterate(context);
    }
}

