/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import java.io.Serializable;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.sort.SubstringMatcher;

public class CodepointCollator
implements StringCollator,
SubstringMatcher,
Serializable {
    private static CodepointCollator theInstance = new CodepointCollator();

    public static CodepointCollator getInstance() {
        return theInstance;
    }

    @Override
    public int compareStrings(String a, String b) {
        return this.compareCS(a, b);
    }

    public int compareCS(CharSequence a, CharSequence b) {
        int nextb;
        int nexta;
        int c;
        int alen = a.length();
        int blen = b.length();
        int i = 0;
        int j = 0;
        do {
            if (i == alen) {
                if (j == blen) {
                    return 0;
                }
                return -1;
            }
            if (j == blen) {
                return 1;
            }
            if ((nexta = a.charAt(i++)) >= 55296 && nexta <= 56319) {
                nexta = (nexta - 55296) * 1024 + (a.charAt(i++) - 56320) + 65536;
            }
            if ((nextb = b.charAt(j++)) < 55296 || nextb > 56319) continue;
            nextb = (nextb - 55296) * 1024 + (b.charAt(j++) - 56320) + 65536;
        } while ((c = nexta - nextb) == 0);
        return c;
    }

    @Override
    public boolean comparesEqual(String s1, String s2) {
        return s1.equals(s2);
    }

    @Override
    public boolean contains(String s1, String s2) {
        return s1.indexOf(s2) >= 0;
    }

    @Override
    public boolean endsWith(String s1, String s2) {
        return s1.endsWith(s2);
    }

    @Override
    public boolean startsWith(String s1, String s2) {
        return s1.startsWith(s2);
    }

    @Override
    public String substringAfter(String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i < 0) {
            return "";
        }
        return s1.substring(i + s2.length());
    }

    @Override
    public String substringBefore(String s1, String s2) {
        int j = s1.indexOf(s2);
        if (j < 0) {
            return "";
        }
        return s1.substring(0, j);
    }

    @Override
    public Object getCollationKey(String s) {
        return s;
    }
}

