/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sort;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.sort.AtomicComparer;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.ComparisonKey;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.StringValue;

public class CodepointCollatingComparer
implements AtomicComparer {
    private static CodepointCollator collator = CodepointCollator.getInstance();
    private static CodepointCollatingComparer THE_INSTANCE = new CodepointCollatingComparer();

    public static CodepointCollatingComparer getInstance() {
        return THE_INSTANCE;
    }

    private CodepointCollatingComparer() {
    }

    @Override
    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    @Override
    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        StringValue as = (StringValue)a;
        StringValue bs = (StringValue)b;
        if (as.containsSurrogatePairs() || bs.containsSurrogatePairs()) {
            return collator.compareCS(as.getStringValueCS(), bs.getStringValueCS());
        }
        return as.getStringValue().compareTo(bs.getStringValue());
    }

    @Override
    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        StringValue as = (StringValue)a;
        StringValue bs = (StringValue)b;
        return as.codepointEquals(bs);
    }

    @Override
    public ComparisonKey getComparisonKey(AtomicValue a) {
        StringValue as = (StringValue)a;
        return new ComparisonKey(513, as.getStringValue());
    }
}

