/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.TransformerReceiver;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.s9api.Destination;
import net2.sf.saxon.s9api.MessageListener;
import net2.sf.saxon.s9api.MessageListenerProxy;
import net2.sf.saxon.s9api.Processor;
import net2.sf.saxon.s9api.QName;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.Serializer;
import net2.sf.saxon.s9api.ValidationMode;
import net2.sf.saxon.s9api.XdmNode;
import net2.sf.saxon.s9api.XdmValue;
import net2.sf.saxon.trace.TraceListener;
import net2.sf.saxon.trans.XPathException;

public class XsltTransformer
implements Destination {
    private Processor processor;
    private Controller controller;
    private NodeInfo initialContextNode;
    private Destination destination;

    protected XsltTransformer(Processor processor, Controller controller) {
        this.processor = processor;
        this.controller = controller;
    }

    public void setInitialTemplate(QName templateName) throws SaxonApiException {
        try {
            this.controller.setInitialTemplate(templateName == null ? null : templateName.getClarkName());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public QName getInitialTemplate() {
        String template = this.controller.getInitialTemplate();
        return template == null ? null : QName.fromClarkName(template);
    }

    public void setInitialMode(QName modeName) {
        this.controller.setInitialMode(modeName == null ? null : modeName.getClarkName());
    }

    public QName getInitialMode() {
        String mode = this.controller.getInitialMode();
        if (mode == null) {
            return null;
        }
        return QName.fromClarkName(mode);
    }

    public void setSchemaValidationMode(ValidationMode mode) {
        if (mode != null) {
            this.controller.setSchemaValidationMode(mode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.controller.getSchemaValidationMode());
    }

    public void setSource(Source source) throws SaxonApiException {
        if (source instanceof NodeInfo) {
            this.setInitialContextNode(new XdmNode((NodeInfo)source));
        } else if (source instanceof DOMSource) {
            this.setInitialContextNode(this.processor.newDocumentBuilder().wrap(source));
        } else {
            this.setInitialContextNode(this.processor.newDocumentBuilder().build(source));
        }
    }

    public void setInitialContextNode(XdmNode node) {
        this.initialContextNode = node == null ? null : node.getUnderlyingNode();
    }

    public XdmNode getInitialContextNode() {
        return (XdmNode)XdmValue.wrap(this.initialContextNode);
    }

    public void setParameter(QName name, XdmValue value) {
        this.controller.setParameter(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getParameter(QName name) {
        Object oval = this.controller.getParameter(name.getClarkName());
        if (oval == null) {
            return null;
        }
        if (oval instanceof ValueRepresentation) {
            return XdmValue.wrap((ValueRepresentation)oval);
        }
        throw new IllegalStateException(oval.getClass().getName());
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setBaseOutputURI(String uri) {
        this.controller.setBaseOutputURI(uri);
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setErrorListener(ErrorListener listener) {
        this.controller.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.controller.getErrorListener();
    }

    public void setMessageListener(MessageListener listener) {
        this.controller.setMessageEmitter(new MessageListenerProxy(listener));
    }

    public MessageListener getMessageListener() {
        Receiver r = this.controller.getMessageEmitter();
        if (r instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)r).getMessageListener();
        }
        return null;
    }

    public void setTraceListener(TraceListener listener) {
        this.controller.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void transform() throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            Receiver receiver = this.destination instanceof Serializer ? ((Serializer)this.destination).getReceiver(this.controller.getConfiguration(), this.controller, this.controller.getOutputProperties()) : this.destination.getReceiver(this.controller.getConfiguration());
            this.controller.transform(this.initialContextNode, receiver);
            if (this.destination instanceof Serializer) {
                ((Serializer)this.destination).close();
            }
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        TransformerReceiver tr = new TransformerReceiver(this.controller);
        tr.setResult(this.destination.getReceiver(config));
        tr.setPipelineConfiguration(this.controller.makePipelineConfiguration());
        return tr;
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

