/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.s9api.SaxonApiUncheckedException;
import net2.sf.saxon.s9api.XdmItem;
import net2.sf.saxon.trans.XPathException;

public class XdmSequenceIterator
implements Iterator<XdmItem> {
    private XdmItem next = null;
    private int state = 0;
    private SequenceIterator base;
    private static final int BEFORE_ITEM = 0;
    private static final int ON_ITEM = 1;
    private static final int FINISHED = 2;

    protected XdmSequenceIterator(SequenceIterator base) {
        this.base = base;
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() throws SaxonApiUncheckedException {
        switch (this.state) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                try {
                    this.next = XdmItem.wrapItem(this.base.next());
                    if (this.next == null) {
                        this.state = 2;
                        return false;
                    }
                    this.state = 1;
                    return true;
                }
                catch (XPathException err) {
                    throw new SaxonApiUncheckedException(err);
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public XdmItem next() {
        switch (this.state) {
            case 1: {
                this.state = 0;
                return this.next;
            }
            case 2: {
                throw new NoSuchElementException();
            }
            case 0: {
                if (this.hasNext()) {
                    this.state = 0;
                    return this.next;
                }
                throw new NoSuchElementException();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

