/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import java.math.BigDecimal;
import java.net.URI;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.om.Name11Checker;
import net2.sf.saxon.s9api.ConstructedItemType;
import net2.sf.saxon.s9api.ItemType;
import net2.sf.saxon.s9api.QName;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.XdmItem;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.DecimalValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.FloatValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.IntegerValue;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.QNameValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public class XdmAtomicValue
extends XdmItem {
    protected XdmAtomicValue(AtomicValue value) {
        super(value);
    }

    public XdmAtomicValue(boolean value) {
        super(BooleanValue.get(value));
    }

    public XdmAtomicValue(long value) {
        super(Int64Value.makeIntegerValue(value));
    }

    public XdmAtomicValue(BigDecimal value) {
        super(new DecimalValue(value));
    }

    public XdmAtomicValue(double value) {
        super(new DoubleValue(value));
    }

    public XdmAtomicValue(float value) {
        super(new FloatValue(value));
    }

    public XdmAtomicValue(String value) {
        super(new StringValue(value));
    }

    public XdmAtomicValue(URI value) {
        super(new AnyURIValue(value.toString()));
    }

    public XdmAtomicValue(QName value) {
        super(new QNameValue(value.getStructuredQName(), BuiltInAtomicType.QNAME));
    }

    public XdmAtomicValue(String lexicalForm, ItemType type) throws SaxonApiException {
        net2.sf.saxon.type.ItemType it = type.getUnderlyingItemType();
        if (!it.isAtomicType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        if (((AtomicType)it).isAbstract()) {
            throw new SaxonApiException("Requested type is an abstract type");
        }
        if (((AtomicType)it).isNamespaceSensitive()) {
            throw new SaxonApiException("Requested type is namespace-sensitive");
        }
        if (((AtomicType)it).isBuiltInType()) {
            ConversionResult cv = StringValue.convertStringToBuiltInType(lexicalForm, (BuiltInAtomicType)it, new Name11Checker());
            try {
                this.setValue(cv.asAtomic());
            }
            catch (ValidationException e) {
                throw new SaxonApiException(e);
            }
        }
        Configuration config = ((ConstructedItemType)type).getProcessor().getUnderlyingConfiguration();
        ConversionResult result = new StringValue(lexicalForm).convert((AtomicType)it, true, config.getConversionContext());
        try {
            this.setValue(result.asAtomic());
        }
        catch (ValidationException e) {
            throw new SaxonApiException(e);
        }
    }

    public String toString() {
        return this.getStringValue();
    }

    public QName getPrimitiveTypeName() {
        AtomicValue value = (AtomicValue)this.getUnderlyingValue();
        BuiltInAtomicType type = value.getPrimitiveType();
        return new QName(type.getQualifiedName());
    }

    public Object getValue() {
        AtomicValue av = (AtomicValue)this.getUnderlyingValue();
        if (av instanceof StringValue) {
            return av.getStringValue();
        }
        if (av instanceof IntegerValue) {
            return ((IntegerValue)av).asBigInteger();
        }
        if (av instanceof DoubleValue) {
            return ((DoubleValue)av).getDoubleValue();
        }
        if (av instanceof FloatValue) {
            return Float.valueOf(((FloatValue)av).getFloatValue());
        }
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof DecimalValue) {
            return ((DecimalValue)av).getDecimalValue();
        }
        if (av instanceof QNameValue) {
            QNameValue q = (QNameValue)av;
            return new QName(q.getPrefix(), q.getNamespaceURI(), q.getLocalName());
        }
        return av.getStringValue();
    }

    public boolean getBooleanValue() throws SaxonApiException {
        AtomicValue av = (AtomicValue)this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof NumericValue) {
            return !av.isNaN() && ((NumericValue)av).signum() != 0.0;
        }
        if (av instanceof StringValue) {
            String s = ((StringValue)av).getStringValue();
            return "1".equals(s) || "true".equals(s);
        }
        throw new SaxonApiException("Cannot cast item to a boolean");
    }

    public long getLongValue() throws SaxonApiException {
        AtomicValue av = (AtomicValue)this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0L : 1L;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).longValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to an integer");
            }
        }
        if (av instanceof StringValue) {
            return (long)Value.stringToNumber(av.getStringValueCS());
        }
        throw new SaxonApiException("Cannot cast item to an integer");
    }

    public double getDoubleValue() throws SaxonApiException {
        AtomicValue av = (AtomicValue)this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0.0 : 1.0;
        }
        if (av instanceof NumericValue) {
            return ((NumericValue)av).getDoubleValue();
        }
        if (av instanceof StringValue) {
            return Value.stringToNumber(av.getStringValueCS());
        }
        throw new SaxonApiException("Cannot cast item to a double");
    }

    public BigDecimal getDecimalValue() throws SaxonApiException {
        AtomicValue av = (AtomicValue)this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? BigDecimal.ZERO : BigDecimal.ONE;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).getDecimalValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to a decimal");
            }
        }
        if (av instanceof StringValue) {
            return new BigDecimal(av.getStringValueCS().toString());
        }
        throw new SaxonApiException("Cannot cast item to a decimal");
    }
}

