/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.s9api.ItemType;
import net2.sf.saxon.s9api.OccurrenceIndicator;
import net2.sf.saxon.s9api.Processor;
import net2.sf.saxon.s9api.QName;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.XPathExecutable;
import net2.sf.saxon.sxpath.IndependentContext;
import net2.sf.saxon.sxpath.XPathEvaluator;
import net2.sf.saxon.sxpath.XPathExpression;
import net2.sf.saxon.sxpath.XPathVariable;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;

public class XPathCompiler {
    private Processor processor;
    private IndependentContext env;

    protected XPathCompiler(Processor processor) {
        this.processor = processor;
        this.env = new IndependentContext(processor.getUnderlyingConfiguration());
    }

    public void setBackwardsCompatible(boolean option) {
        this.env.setBackwardsCompatibilityMode(option);
    }

    public boolean isBackwardsCompatible() {
        return this.env.isInBackwardsCompatibleMode();
    }

    public void setBaseURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.env.setBaseURI(uri.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void declareNamespace(String prefix, String uri) {
        this.env.declareNamespace(prefix, uri);
    }

    public void importSchemaNamespace(String uri) {
        this.env.getImportedSchemaNamespaces().add(uri);
    }

    public void setAllowUndeclaredVariables(boolean allow) {
        this.env.setAllowUndeclaredVariables(allow);
    }

    public boolean isAllowUndeclaredVariables() {
        return this.env.isAllowUndeclaredVariables();
    }

    public void declareVariable(QName qname) {
        this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
    }

    public void declareVariable(QName qname, ItemType itemType, OccurrenceIndicator occurrences) throws SaxonApiException {
        XPathVariable var = this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
        var.setRequiredType(SequenceType.makeSequenceType(itemType.getUnderlyingItemType(), occurrences.getCardinality()));
    }

    public XPathExecutable compile(String source) throws SaxonApiException {
        IndependentContext ic = this.env;
        if (ic.isAllowUndeclaredVariables()) {
            ic = this.env.copy();
            Iterator<XPathVariable> iter = this.env.iterateExternalVariables();
            while (iter.hasNext()) {
                XPathVariable var = iter.next();
                XPathVariable var2 = ic.declareVariable(var.getVariableQName());
                var2.setRequiredType(var.getRequiredType());
            }
        }
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(ic);
            XPathExpression cexp = eval.createExpression(source);
            return new XPathExecutable(cexp, this.processor, ic);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XPathExecutable compilePattern(String source) throws SaxonApiException {
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(this.env);
            XPathExpression cexp = eval.createPattern(source);
            return new XPathExecutable(cexp, this.processor, this.env);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StaticContext getUnderlyingStaticContext() {
        return this.env;
    }
}

