/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.s9api.Destination;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.SchemaValidator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaException;
import net2.sf.saxon.type.SchemaURIResolver;

public class SchemaManager {
    private Configuration config;
    private ErrorListener errorListener;

    protected SchemaManager(Configuration config) {
        this.config = config;
        this.errorListener = null;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.config.setSchemaURIResolver(resolver);
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.config.getSchemaURIResolver();
    }

    public void load(Source source) throws SaxonApiException {
        try {
            this.config.addSchemaSource(source, this.errorListener);
        }
        catch (SchemaException e) {
            throw new SaxonApiException(e);
        }
    }

    public void importComponents(Source source) throws SaxonApiException {
        try {
            this.config.importComponents(source);
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    public void exportComponents(Destination destination) throws SaxonApiException {
        try {
            Receiver out = destination.getReceiver(this.config);
            this.config.exportComponents(out);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public SchemaValidator newSchemaValidator() {
        return new SchemaValidator(this.config);
    }
}

