/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StandardNames;
import net2.sf.saxon.pattern.CombinedNodeTest;
import net2.sf.saxon.pattern.ContentTypeTest;
import net2.sf.saxon.pattern.DocumentNodeTest;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.s9api.ConstructedItemType;
import net2.sf.saxon.s9api.ItemType;
import net2.sf.saxon.s9api.Processor;
import net2.sf.saxon.s9api.QName;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.XdmAtomicValue;
import net2.sf.saxon.s9api.XdmItem;
import net2.sf.saxon.s9api.XdmNodeKind;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.ExternalObjectType;
import net2.sf.saxon.type.SchemaDeclaration;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.ObjectValue;

public class ItemTypeFactory {
    private Processor processor;

    public ItemTypeFactory(Processor processor) {
        this.processor = processor;
    }

    public ItemType getAtomicType(QName name) throws SaxonApiException {
        int fp;
        String uri = name.getNamespaceURI();
        String local = name.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            int fp2 = StandardNames.getFingerprint(uri, local);
            switch (fp2) {
                case 632: {
                    return ItemType.ANY_ATOMIC_VALUE;
                }
                case 635: {
                    return ItemType.NUMERIC;
                }
                case 513: {
                    return ItemType.STRING;
                }
                case 514: {
                    return ItemType.BOOLEAN;
                }
                case 518: {
                    return ItemType.DURATION;
                }
                case 519: {
                    return ItemType.DATE_TIME;
                }
                case 521: {
                    return ItemType.DATE;
                }
                case 520: {
                    return ItemType.TIME;
                }
                case 522: {
                    return ItemType.G_YEAR_MONTH;
                }
                case 526: {
                    return ItemType.G_MONTH;
                }
                case 524: {
                    return ItemType.G_MONTH_DAY;
                }
                case 523: {
                    return ItemType.G_YEAR;
                }
                case 525: {
                    return ItemType.G_DAY;
                }
                case 527: {
                    return ItemType.HEX_BINARY;
                }
                case 528: {
                    return ItemType.BASE64_BINARY;
                }
                case 529: {
                    return ItemType.ANY_URI;
                }
                case 530: {
                    return ItemType.QNAME;
                }
                case 531: {
                    return ItemType.NOTATION;
                }
                case 631: {
                    return ItemType.UNTYPED_ATOMIC;
                }
                case 515: {
                    return ItemType.DECIMAL;
                }
                case 516: {
                    return ItemType.FLOAT;
                }
                case 517: {
                    return ItemType.DOUBLE;
                }
                case 532: {
                    return ItemType.INTEGER;
                }
                case 533: {
                    return ItemType.NON_POSITIVE_INTEGER;
                }
                case 534: {
                    return ItemType.NEGATIVE_INTEGER;
                }
                case 535: {
                    return ItemType.LONG;
                }
                case 536: {
                    return ItemType.INT;
                }
                case 537: {
                    return ItemType.SHORT;
                }
                case 538: {
                    return ItemType.BYTE;
                }
                case 539: {
                    return ItemType.NON_NEGATIVE_INTEGER;
                }
                case 540: {
                    return ItemType.POSITIVE_INTEGER;
                }
                case 541: {
                    return ItemType.UNSIGNED_LONG;
                }
                case 542: {
                    return ItemType.UNSIGNED_INT;
                }
                case 543: {
                    return ItemType.UNSIGNED_SHORT;
                }
                case 544: {
                    return ItemType.UNSIGNED_BYTE;
                }
                case 633: {
                    return ItemType.YEAR_MONTH_DURATION;
                }
                case 634: {
                    return ItemType.DAY_TIME_DURATION;
                }
                case 553: {
                    return ItemType.NORMALIZED_STRING;
                }
                case 554: {
                    return ItemType.TOKEN;
                }
                case 555: {
                    return ItemType.LANGUAGE;
                }
                case 558: {
                    return ItemType.NAME;
                }
                case 556: {
                    return ItemType.NMTOKEN;
                }
                case 559: {
                    return ItemType.NCNAME;
                }
                case 560: {
                    return ItemType.ID;
                }
                case 561: {
                    return ItemType.IDREF;
                }
                case 563: {
                    return ItemType.ENTITY;
                }
                case 565: {
                    return ItemType.DATE_TIME_STAMP;
                }
            }
            throw new SaxonApiException("Unknown atomic type " + name.getClarkName());
        }
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaType type = config.getSchemaType(fp = config.getNamePool().allocate("", name.getNamespaceURI(), local) & 0xFFFFF);
        if (type == null || !type.isAtomicType()) {
            throw new SaxonApiException("Unknown atomic type " + name.getClarkName());
        }
        return new ConstructedItemType((AtomicType)type, this.processor);
    }

    public ItemType getNodeKindTest(XdmNodeKind kind) {
        switch (kind) {
            case DOCUMENT: {
                return new ConstructedItemType(NodeKindTest.DOCUMENT, this.processor);
            }
            case ELEMENT: {
                return new ConstructedItemType(NodeKindTest.ELEMENT, this.processor);
            }
            case ATTRIBUTE: {
                return new ConstructedItemType(NodeKindTest.ATTRIBUTE, this.processor);
            }
            case TEXT: {
                return new ConstructedItemType(NodeKindTest.TEXT, this.processor);
            }
            case COMMENT: {
                return new ConstructedItemType(NodeKindTest.COMMENT, this.processor);
            }
            case PROCESSING_INSTRUCTION: {
                return new ConstructedItemType(NodeKindTest.PROCESSING_INSTRUCTION, this.processor);
            }
            case NAMESPACE: {
                return new ConstructedItemType(NodeKindTest.NAMESPACE, this.processor);
            }
        }
        throw new IllegalArgumentException("XdmNodeKind");
    }

    public ItemType getItemType(XdmNodeKind kind, QName name) {
        int k = kind.getNumber();
        if (k == 1 || k == 2 || k == 7) {
            if (k == 7 && name.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("The name of a processing instruction must not be in a namespace");
            }
            NameTest type = new NameTest(k, name.getNamespaceURI(), name.getLocalName(), this.processor.getUnderlyingConfiguration().getNamePool());
            return new ConstructedItemType(type, this.processor);
        }
        throw new IllegalArgumentException("Node kind must be element, attribute, or processing-instruction");
    }

    public ItemType getSchemaElementTest(QName name) throws SaxonApiException {
        int fingerprint;
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaDeclaration decl = config.getElementDeclaration(fingerprint = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName()));
        if (decl == null) {
            throw new SaxonApiException("No global declaration found for element " + name.getClarkName());
        }
        CombinedNodeTest combo = new CombinedNodeTest(new NameTest(1, fingerprint, config.getNamePool()), 23, new ContentTypeTest(1, decl.getType(), config));
        combo.setGlobalComponentTest(true);
        return new ConstructedItemType(combo, this.processor);
    }

    public ItemType getElementTest(QName name, QName schemaType, boolean nillable) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        NameTest nameTest = null;
        ContentTypeTest contentTest = null;
        if (name != null) {
            int elementFP = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
            nameTest = new NameTest(1, elementFP, config.getNamePool());
        }
        if (schemaType != null) {
            int typeFP = config.getNamePool().allocate("", schemaType.getNamespaceURI(), schemaType.getLocalName());
            SchemaType type = config.getSchemaType(typeFP);
            if (type == null) {
                throw new SaxonApiException("Unknown schema type " + schemaType.getClarkName());
            }
            contentTest = new ContentTypeTest(1, type, config);
            contentTest.setNillable(nillable);
        }
        if (contentTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ELEMENT);
            }
            return new ConstructedItemType(nameTest, this.processor);
        }
        if (nameTest == null) {
            return new ConstructedItemType(contentTest, this.processor);
        }
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, contentTest);
        return new ConstructedItemType(combo, this.processor);
    }

    public ItemType getSchemaAttributeTest(QName name) throws SaxonApiException {
        int fingerprint;
        Configuration config = this.processor.getUnderlyingConfiguration();
        SchemaDeclaration decl = config.getAttributeDeclaration(fingerprint = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName()));
        if (decl == null) {
            throw new SaxonApiException("No global declaration found for attribute " + name.getClarkName());
        }
        CombinedNodeTest combo = new CombinedNodeTest(new NameTest(2, fingerprint, config.getNamePool()), 23, new ContentTypeTest(2, decl.getType(), config));
        combo.setGlobalComponentTest(true);
        return new ConstructedItemType(combo, this.processor);
    }

    public ItemType getAttributeTest(QName name, QName schemaType) throws SaxonApiException {
        NameTest nameTest = null;
        ContentTypeTest contentTest = null;
        Configuration config = this.processor.getUnderlyingConfiguration();
        if (name != null) {
            int attributeFP = config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
            nameTest = new NameTest(2, attributeFP, config.getNamePool());
        }
        if (schemaType != null) {
            int typeFP = config.getNamePool().allocate("", schemaType.getNamespaceURI(), schemaType.getLocalName());
            SchemaType type = config.getSchemaType(typeFP);
            if (type == null) {
                throw new SaxonApiException("Unknown schema type " + schemaType.getClarkName());
            }
            contentTest = new ContentTypeTest(2, type, config);
        }
        if (contentTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ATTRIBUTE);
            }
            return new ConstructedItemType(nameTest, this.processor);
        }
        if (nameTest == null) {
            return new ConstructedItemType(contentTest, this.processor);
        }
        CombinedNodeTest combo = new CombinedNodeTest(nameTest, 23, contentTest);
        return new ConstructedItemType(combo, this.processor);
    }

    public ItemType getDocumentTest(ItemType elementTest) {
        net2.sf.saxon.type.ItemType test = elementTest.getUnderlyingItemType();
        if (test.getPrimitiveType() != 1) {
            throw new IllegalArgumentException("Supplied itemType is not an element test");
        }
        DocumentNodeTest docTest = new DocumentNodeTest((NodeTest)test);
        return new ConstructedItemType(docTest, this.processor);
    }

    public ItemType getExternalObjectType(Class externalClass) {
        ExternalObjectType type = new ExternalObjectType(externalClass, this.processor.getUnderlyingConfiguration());
        return new ConstructedItemType(type, this.processor);
    }

    public XdmAtomicValue getExternalObject(Object object) {
        ExternalObjectType type = new ExternalObjectType(object.getClass(), this.processor.getUnderlyingConfiguration());
        return (XdmAtomicValue)XdmItem.wrap(new ObjectValue(object, type));
    }

    public ItemType getItemType(XdmItem item) {
        Configuration config = this.processor.getUnderlyingConfiguration();
        if (item.isAtomicValue()) {
            AtomicValue value = (AtomicValue)item.getUnderlyingValue();
            AtomicType type = (AtomicType)value.getItemType(config.getTypeHierarchy());
            return new ConstructedItemType(type, this.processor);
        }
        NodeInfo node = (NodeInfo)item.getUnderlyingValue();
        int kind = node.getNodeKind();
        int fp = node.getFingerprint();
        if (fp == -1) {
            return new ConstructedItemType(NodeKindTest.makeNodeKindTest(kind), this.processor);
        }
        return new ConstructedItemType(new NameTest(kind, fp, config.getNamePool()), this.processor);
    }
}

