/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.s9api.XdmItem;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.AtomicValue;

public abstract class ItemType {
    public static ItemType ANY_ITEM = new ItemType(){

        @Override
        public boolean matches(XdmItem item) {
            return true;
        }

        @Override
        public boolean subsumes(ItemType other) {
            return true;
        }

        @Override
        public net2.sf.saxon.type.ItemType getUnderlyingItemType() {
            return AnyItemType.getInstance();
        }
    };
    public static ItemType ANY_NODE = new ItemType(){

        @Override
        public boolean matches(XdmItem item) {
            return item.getUnderlyingValue() instanceof NodeInfo;
        }

        @Override
        public boolean subsumes(ItemType other) {
            return other.getUnderlyingItemType() instanceof NodeTest;
        }

        @Override
        public net2.sf.saxon.type.ItemType getUnderlyingItemType() {
            return AnyNodeTest.getInstance();
        }
    };
    public static ItemType ANY_ATOMIC_VALUE = new ItemType(){

        @Override
        public boolean matches(XdmItem item) {
            return item.getUnderlyingValue() instanceof AtomicValue;
        }

        @Override
        public boolean subsumes(ItemType other) {
            return other.getUnderlyingItemType() instanceof AtomicType;
        }

        @Override
        public net2.sf.saxon.type.ItemType getUnderlyingItemType() {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    };
    public static ItemType NUMERIC = new BuiltInAtomicItemType(BuiltInAtomicType.NUMERIC);
    public static ItemType STRING = new BuiltInAtomicItemType(BuiltInAtomicType.STRING);
    public static ItemType BOOLEAN = new BuiltInAtomicItemType(BuiltInAtomicType.BOOLEAN);
    public static ItemType DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.DURATION);
    public static ItemType DATE_TIME = new BuiltInAtomicItemType(BuiltInAtomicType.DATE_TIME);
    public static ItemType DATE = new BuiltInAtomicItemType(BuiltInAtomicType.DATE);
    public static ItemType TIME = new BuiltInAtomicItemType(BuiltInAtomicType.TIME);
    public static ItemType G_YEAR_MONTH = new BuiltInAtomicItemType(BuiltInAtomicType.G_YEAR_MONTH);
    public static ItemType G_MONTH = new BuiltInAtomicItemType(BuiltInAtomicType.G_MONTH);
    public static ItemType G_MONTH_DAY = new BuiltInAtomicItemType(BuiltInAtomicType.G_MONTH_DAY);
    public static ItemType G_YEAR = new BuiltInAtomicItemType(BuiltInAtomicType.G_YEAR);
    public static ItemType G_DAY = new BuiltInAtomicItemType(BuiltInAtomicType.G_DAY);
    public static ItemType HEX_BINARY = new BuiltInAtomicItemType(BuiltInAtomicType.HEX_BINARY);
    public static ItemType BASE64_BINARY = new BuiltInAtomicItemType(BuiltInAtomicType.BASE64_BINARY);
    public static ItemType ANY_URI = new BuiltInAtomicItemType(BuiltInAtomicType.ANY_URI);
    public static ItemType QNAME = new BuiltInAtomicItemType(BuiltInAtomicType.QNAME);
    public static ItemType NOTATION = new BuiltInAtomicItemType(BuiltInAtomicType.NOTATION);
    public static ItemType UNTYPED_ATOMIC = new BuiltInAtomicItemType(BuiltInAtomicType.UNTYPED_ATOMIC);
    public static ItemType DECIMAL = new BuiltInAtomicItemType(BuiltInAtomicType.DECIMAL);
    public static ItemType FLOAT = new BuiltInAtomicItemType(BuiltInAtomicType.FLOAT);
    public static ItemType DOUBLE = new BuiltInAtomicItemType(BuiltInAtomicType.DOUBLE);
    public static ItemType INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.INTEGER);
    public static ItemType NON_POSITIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NON_POSITIVE_INTEGER);
    public static ItemType NEGATIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NEGATIVE_INTEGER);
    public static ItemType LONG = new BuiltInAtomicItemType(BuiltInAtomicType.LONG);
    public static ItemType INT = new BuiltInAtomicItemType(BuiltInAtomicType.INT);
    public static ItemType SHORT = new BuiltInAtomicItemType(BuiltInAtomicType.SHORT);
    public static ItemType BYTE = new BuiltInAtomicItemType(BuiltInAtomicType.BYTE);
    public static ItemType NON_NEGATIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.NON_NEGATIVE_INTEGER);
    public static ItemType POSITIVE_INTEGER = new BuiltInAtomicItemType(BuiltInAtomicType.POSITIVE_INTEGER);
    public static ItemType UNSIGNED_LONG = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_LONG);
    public static ItemType UNSIGNED_INT = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_INT);
    public static ItemType UNSIGNED_SHORT = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_SHORT);
    public static ItemType UNSIGNED_BYTE = new BuiltInAtomicItemType(BuiltInAtomicType.UNSIGNED_BYTE);
    public static ItemType YEAR_MONTH_DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.YEAR_MONTH_DURATION);
    public static ItemType DAY_TIME_DURATION = new BuiltInAtomicItemType(BuiltInAtomicType.DAY_TIME_DURATION);
    public static ItemType NORMALIZED_STRING = new BuiltInAtomicItemType(BuiltInAtomicType.NORMALIZED_STRING);
    public static ItemType TOKEN = new BuiltInAtomicItemType(BuiltInAtomicType.TOKEN);
    public static ItemType LANGUAGE = new BuiltInAtomicItemType(BuiltInAtomicType.LANGUAGE);
    public static ItemType NAME = new BuiltInAtomicItemType(BuiltInAtomicType.NAME);
    public static ItemType NMTOKEN = new BuiltInAtomicItemType(BuiltInAtomicType.NMTOKEN);
    public static ItemType NCNAME = new BuiltInAtomicItemType(BuiltInAtomicType.NCNAME);
    public static ItemType ID = new BuiltInAtomicItemType(BuiltInAtomicType.ID);
    public static ItemType IDREF = new BuiltInAtomicItemType(BuiltInAtomicType.IDREF);
    public static ItemType ENTITY = new BuiltInAtomicItemType(BuiltInAtomicType.ENTITY);
    public static ItemType DATE_TIME_STAMP = new BuiltInAtomicItemType(BuiltInAtomicType.DATE_TIME_STAMP);

    public abstract boolean matches(XdmItem var1);

    public abstract boolean subsumes(ItemType var1);

    public abstract net2.sf.saxon.type.ItemType getUnderlyingItemType();

    private static class BuiltInAtomicItemType
    extends ItemType {
        private BuiltInAtomicType underlyingType;

        public BuiltInAtomicItemType(BuiltInAtomicType underlyingType) {
            this.underlyingType = underlyingType;
        }

        @Override
        public boolean matches(XdmItem item) {
            Item value = (Item)item.getUnderlyingValue();
            if (!(value instanceof AtomicValue)) {
                return false;
            }
            AtomicType type = ((AtomicValue)value).getTypeLabel();
            return this.subsumesUnderlyingType(type);
        }

        @Override
        public boolean subsumes(ItemType other) {
            net2.sf.saxon.type.ItemType otherType = other.getUnderlyingItemType();
            if (!otherType.isAtomicType()) {
                return false;
            }
            AtomicType type = (AtomicType)otherType;
            return this.subsumesUnderlyingType(type);
        }

        private boolean subsumesUnderlyingType(AtomicType type) {
            BuiltInAtomicType builtIn;
            BuiltInAtomicType builtInAtomicType = builtIn = type instanceof BuiltInAtomicType ? (BuiltInAtomicType)type : (BuiltInAtomicType)type.getBuiltInBaseType();
            while (!builtIn.isSameType(this.underlyingType)) {
                SchemaType base = builtIn.getBaseType();
                if (!(base instanceof BuiltInAtomicType)) {
                    return false;
                }
                builtIn = (BuiltInAtomicType)base;
            }
            return true;
        }

        @Override
        public net2.sf.saxon.type.ItemType getUnderlyingItemType() {
            return this.underlyingType;
        }
    }
}

