/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.s9api;

import java.io.File;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.AugmentedSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.ParseOptions;
import net2.sf.saxon.expr.EarlyEvaluationContext;
import net2.sf.saxon.expr.JPConverter;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.TreeModel;
import net2.sf.saxon.s9api.SaxonApiException;
import net2.sf.saxon.s9api.SchemaValidator;
import net2.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net2.sf.saxon.s9api.XdmItem;
import net2.sf.saxon.s9api.XdmNode;
import net2.sf.saxon.trans.XPathException;

public class DocumentBuilder {
    private Configuration config;
    private SchemaValidator schemaValidator;
    private boolean retainPSVI = true;
    private boolean dtdValidation;
    private boolean lineNumbering;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private WhitespaceStrippingPolicy whitespacePolicy;
    private URI baseURI;

    protected DocumentBuilder(Configuration config) {
        this.config = config;
    }

    public void setTreeModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setLineNumbering(boolean option) {
        this.lineNumbering = option;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setSchemaValidator(SchemaValidator validator) {
        this.schemaValidator = validator;
    }

    public SchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    public void setRetainPSVI(boolean retainPSVI) {
        this.retainPSVI = retainPSVI;
    }

    public boolean isRetainPSVI() {
        return this.retainPSVI;
    }

    public void setDTDValidation(boolean option) {
        this.dtdValidation = option;
    }

    public boolean isDTDValidation() {
        return this.dtdValidation;
    }

    public void setWhitespaceStrippingPolicy(WhitespaceStrippingPolicy policy) {
        this.whitespacePolicy = policy;
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return this.whitespacePolicy;
    }

    public void setBaseURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.baseURI = uri;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public XdmNode build(Source source) throws SaxonApiException {
        if (source instanceof AugmentedSource) {
            throw new IllegalArgumentException("AugmentedSource not accepted");
        }
        ParseOptions options = new ParseOptions();
        options.setDTDValidationMode(this.dtdValidation ? 1 : 4);
        if (this.schemaValidator != null) {
            options.setSchemaValidationMode(this.schemaValidator.isLax() ? 2 : 1);
            if (this.schemaValidator.getDocumentElementName() != null) {
                options.setTopLevelElement(this.schemaValidator.getDocumentElementName().getStructuredQName());
            }
            if (this.schemaValidator.getDocumentElementType() != null) {
                options.setTopLevelType(this.schemaValidator.getDocumentElementType());
            }
        }
        if (this.treeModel != null) {
            options.setModel(this.treeModel);
        }
        if (this.whitespacePolicy != null) {
            options.setStripSpace(this.whitespacePolicy.ordinal());
        }
        options.setLineNumbering(this.lineNumbering);
        if (source.getSystemId() == null && this.baseURI != null) {
            source.setSystemId(this.baseURI.toString());
        }
        try {
            DocumentInfo doc = this.config.buildDocument(source, options);
            return new XdmNode(doc);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmNode build(File file) throws SaxonApiException {
        return this.build(new StreamSource(file));
    }

    public XdmNode wrap(Object node) throws IllegalArgumentException {
        if (node instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)node;
            if (nodeInfo.getConfiguration().isCompatible(this.config)) {
                return new XdmNode((NodeInfo)node);
            }
            throw new IllegalArgumentException("Supplied NodeInfo was created using a different Configuration");
        }
        try {
            JPConverter converter = JPConverter.allocate(node.getClass(), this.config);
            NodeInfo nodeInfo = (NodeInfo)converter.convert(node, new EarlyEvaluationContext(this.config, null));
            return (XdmNode)XdmItem.wrapItem(nodeInfo);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

