/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net2.sf.saxon.om.ArrayIterator;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.regex.RegexIterator;
import net2.sf.saxon.value.StringValue;

public class JRegexIterator
implements RegexIterator {
    private String theString;
    private Pattern pattern;
    private Matcher matcher;
    private String current;
    private String next;
    private int position = 0;
    private int prevEnd = 0;

    public JRegexIterator(String string, Pattern pattern) {
        this.theString = string;
        this.pattern = pattern;
        this.matcher = pattern.matcher(string);
        this.next = null;
    }

    @Override
    public Item next() {
        if (this.next == null && this.prevEnd >= 0) {
            if (this.matcher.find()) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                if (this.prevEnd == start) {
                    this.next = null;
                    this.current = this.theString.substring(start, end);
                    this.prevEnd = end;
                } else {
                    this.current = this.theString.substring(this.prevEnd, start);
                    this.next = this.theString.substring(start, end);
                }
            } else {
                if (this.prevEnd >= this.theString.length()) {
                    this.current = null;
                    this.position = -1;
                    this.prevEnd = -1;
                    return null;
                }
                this.current = this.theString.substring(this.prevEnd);
                this.next = null;
                this.prevEnd = -1;
            }
        } else if (this.prevEnd >= 0) {
            this.current = this.next;
            this.next = null;
            this.prevEnd = this.matcher.end();
        } else {
            this.current = null;
            this.position = -1;
            return null;
        }
        ++this.position;
        return StringValue.makeStringValue(this.current);
    }

    @Override
    public Item current() {
        return StringValue.makeStringValue(this.current);
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() {
        return new JRegexIterator(this.theString, this.pattern);
    }

    @Override
    public int getProperties() {
        return 0;
    }

    @Override
    public boolean isMatching() {
        return this.next == null && this.prevEnd >= 0;
    }

    @Override
    public String getRegexGroup(int number) {
        if (!this.isMatching()) {
            return null;
        }
        if (number > this.matcher.groupCount() || number < 0) {
            return "";
        }
        String s = this.matcher.group(number);
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public SequenceIterator getRegexGroupIterator() {
        int c = this.matcher.groupCount();
        if (c == 0) {
            return EmptyIterator.getInstance();
        }
        Item[] groups = new StringValue[c];
        int i = 1;
        while (i <= groups.length) {
            groups[i - 1] = StringValue.makeStringValue(this.matcher.group(i));
            ++i;
        }
        return new ArrayIterator(groups);
    }
}

