/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net2.sf.saxon.charcode.XMLCharacterData;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.regex.CaseVariants;
import net2.sf.saxon.regex.RegexData;
import net2.sf.saxon.regex.RegexSyntaxException;
import net2.sf.saxon.regex.RegexTranslator;
import net2.sf.saxon.sort.IntRangeSet;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Whitespace;

public class JDK15RegexTranslator
extends RegexTranslator {
    public static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    public static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    public static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT_SCHEMA = new Complement(new Union(new CharClass[]{new SingleChar(10), new SingleChar(13)}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{JDK15RegexTranslator.computeCategoryCharClass('P'), JDK15RegexTranslator.computeCategoryCharClass('Z'), JDK15RegexTranslator.computeCategoryCharClass('C')});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(32), new SingleChar(10), new SingleChar(13), new SingleChar(9)});
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i_10 = JDK15RegexTranslator.makeNameCharClass((byte)4);
    private static final CharClass ESC_i_11 = JDK15RegexTranslator.makeNameCharClass((byte)32);
    private static final CharClass ESC_I_10 = new Complement(ESC_i_10);
    private static final CharClass ESC_I_11 = new Complement(ESC_i_11);
    private static final CharClass ESC_c_10 = JDK15RegexTranslator.makeNameCharClass((byte)2);
    private static final CharClass ESC_c_11 = JDK15RegexTranslator.makeNameCharClass((byte)16);
    private static final CharClass ESC_C_10 = new Complement(ESC_c_10);
    private static final CharClass ESC_C_11 = new Complement(ESC_c_11);

    private JDK15RegexTranslator() {
    }

    public static String translate(CharSequence regExp, int xmlVersion, boolean xpath, boolean ignoreWhitespace, boolean caseBlind) throws RegexSyntaxException {
        JDK15RegexTranslator tr = new JDK15RegexTranslator();
        tr.regExp = regExp;
        tr.length = regExp.length();
        tr.xmlVersion = xmlVersion;
        tr.isXPath = xpath;
        tr.ignoreWhitespace = ignoreWhitespace;
        tr.caseBlind = caseBlind;
        tr.advance();
        tr.translateTop();
        return tr.result.toString();
    }

    @Override
    protected boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                int thisCapture = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(thisCapture);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.inCharClassExpr = true;
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) break;
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
                break;
            }
            default: {
                int thisChar;
                int[] variants;
                if (!this.caseBlind || (variants = CaseVariants.getCaseVariants(thisChar = this.absorbSurrogatePair())).length <= 0) break;
                CharClass[] chars = new CharClass[variants.length + 1];
                chars[0] = new SingleChar(thisChar);
                int i = 0;
                while (i < variants.length) {
                    chars[i + 1] = new SingleChar(variants[i]);
                    ++i;
                }
                Union union = new Union(chars);
                union.output(this.result);
                this.advance();
                return true;
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeNameCharClass(byte mask) {
        ArrayList<SimpleCharClass> ranges = new ArrayList<SimpleCharClass>();
        ranges.add(new SingleChar(58));
        IntRangeSet members = XMLCharacterData.getCategory(mask);
        int used = members.getNumberOfRanges();
        int[] startPoints = members.getStartPoints();
        int[] endPoints = members.getEndPoints();
        int i = 0;
        while (i < used) {
            if (startPoints[i] == endPoints[i]) {
                ranges.add(new SingleChar(startPoints[i]));
            } else {
                ranges.add(new CharRange(startPoints[i], endPoints[i]));
            }
            ++i;
        }
        return new Union(ranges);
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar(10, true);
            }
            case 'r': {
                this.advance();
                return new SingleChar(13, true);
            }
            case 't': {
                this.advance();
                return new SingleChar(9, true);
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_i_10 : ESC_i_11;
            }
            case 'I': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_I_10 : ESC_I_11;
            }
            case 'c': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_c_10 : ESC_c_11;
            }
            case 'C': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_C_10 : ESC_C_11;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            case '0': {
                throw this.makeException("backreference cannot start with digit zero");
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    if (this.inCharClassExpr) {
                        throw this.makeException("back-reference not allowed within []");
                    }
                    int backRef = this.curChar - 48;
                    while (true) {
                        int backRef2;
                        this.advance();
                        int c1 = "0123456789".indexOf(this.curChar);
                        if (c1 < 0 || (backRef2 = backRef * 10 + c1) > this.currentCapture) break;
                        backRef = backRef2;
                    }
                    if (!this.captures.contains(backRef)) {
                        String explanation = backRef > this.currentCapture ? "(no such group)" : "(group not yet closed)";
                        throw this.makeException("invalid backreference \\" + backRef + " " + explanation);
                    }
                    return new BackReference(backRef);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SingleChar tem = new SingleChar(this.curChar, true);
        this.advance();
        return tem;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int start = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK15RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        CharSequence propertyNameCS = this.regExp.subSequence(start, this.pos - 1);
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            propertyNameCS = Whitespace.removeAllWhitespace(propertyNameCS);
        }
        String propertyName = propertyNameCS.toString();
        this.advance();
        switch (propertyName.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int sci = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".indexOf(propertyName);
                if (sci < 0 || sci % 2 == 1) {
                    throw this.makeException("unknown category");
                }
                return JDK15RegexTranslator.getSubCategoryCharClass(sci / 2);
            }
            case 1: {
                int ci = "LMNPZSC".indexOf(propertyName.charAt(0));
                if (ci < 0) {
                    throw this.makeException("unknown category", propertyName);
                }
                return JDK15RegexTranslator.getCategoryCharClass(ci);
            }
        }
        if (propertyName.startsWith("Is")) {
            String blockName = propertyName.substring(2);
            int i = 0;
            while (i < RegexData.specialBlockNames.length) {
                if (blockName.equals(RegexData.specialBlockNames[i])) {
                    return specialBlockCharClasses[i];
                }
                ++i;
            }
            if (!JDK15RegexTranslator.isBlock(blockName)) {
                throw this.makeException("invalid block name", blockName);
            }
            return new Property("In" + blockName);
        }
        throw this.makeException("invalid property name", propertyName);
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        boolean compl;
        if (this.curChar == '^') {
            this.advance();
            compl = true;
        } else {
            compl = false;
        }
        ArrayList<CharClass> members = new ArrayList<CharClass>(10);
        do {
            CharClass lower = this.parseCharClassEscOrXmlChar();
            members.add(lower);
            if (this.curChar == ']' || this.eos) {
                this.addCaseVariant(lower, members);
                break;
            }
            if (this.curChar == '-') {
                char next = this.regExp.charAt(this.pos);
                if (next == '[') {
                    this.addCaseVariant(lower, members);
                    this.advance();
                    break;
                }
                if (next == ']') {
                    this.addCaseVariant(lower, members);
                    continue;
                }
                this.advance();
                CharClass upper = this.parseCharClassEscOrXmlChar();
                if (lower.getSingleChar() < 0 || upper.getSingleChar() < 0) {
                    throw this.makeException("the ends of a range must be single characters");
                }
                if (lower.getSingleChar() > upper.getSingleChar()) {
                    throw this.makeException("invalid range (start > end)");
                }
                if (lower instanceof SingleChar && lower.getSingleChar() == 45 && !((SingleChar)lower).isEscaped) {
                    throw this.makeException("range cannot start with unescaped hyphen");
                }
                if (upper instanceof SingleChar && upper.getSingleChar() == 45 && !((SingleChar)upper).isEscaped) {
                    throw this.makeException("range cannot end with unescaped hyphen");
                }
                members.set(members.size() - 1, new CharRange(lower.getSingleChar(), upper.getSingleChar()));
                if (this.caseBlind) {
                    int v;
                    if (lower.getSingleChar() == 97 && upper.getSingleChar() == 122) {
                        members.add(new CharRange(65, 90));
                        v = 0;
                        while (v < CaseVariants.ROMAN_VARIANTS.length) {
                            members.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[v]));
                            ++v;
                        }
                    } else if (lower.getSingleChar() == 65 && upper.getSingleChar() == 90) {
                        members.add(new CharRange(97, 122));
                        v = 0;
                        while (v < CaseVariants.ROMAN_VARIANTS.length) {
                            members.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[v]));
                            ++v;
                        }
                    } else {
                        int k = lower.getSingleChar();
                        while (k <= upper.getSingleChar()) {
                            int[] variants = CaseVariants.getCaseVariants(k);
                            int v2 = 0;
                            while (v2 < variants.length) {
                                members.add(new SingleChar(variants[v2]));
                                ++v2;
                            }
                            ++k;
                        }
                    }
                }
                if (this.curChar != '-' || this.regExp.charAt(this.pos) != '[') continue;
                this.advance();
                break;
            }
            this.addCaseVariant(lower, members);
        } while (this.curChar != ']');
        if (this.eos) {
            this.expect(']');
        }
        CharClass result = members.size() == 1 ? (CharClass)members.get(0) : new Union(members);
        if (compl) {
            result = new Complement(result);
        }
        if (this.curChar == '[') {
            this.advance();
            result = new Subtraction(result, this.parseCharClassExpr());
            this.expect(']');
        }
        this.inCharClassExpr = false;
        this.advance();
        return result;
    }

    private void addCaseVariant(CharClass lower, List members) {
        if (this.caseBlind) {
            int[] variants = CaseVariants.getCaseVariants(lower.getSingleChar());
            int v = 0;
            while (v < variants.length) {
                members.add(new SingleChar(variants[v]));
                ++v;
            }
        }
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        SingleChar tem = new SingleChar(this.absorbSurrogatePair());
        this.advance();
        return tem;
    }

    private static synchronized CharClass getCategoryCharClass(int ci) {
        if (categoryCharClasses[ci] == null) {
            JDK15RegexTranslator.categoryCharClasses[ci] = JDK15RegexTranslator.computeCategoryCharClass("LMNPZSC".charAt(ci));
        }
        return categoryCharClasses[ci];
    }

    private static synchronized CharClass getSubCategoryCharClass(int sci) {
        if (subCategoryCharClasses[sci] == null) {
            JDK15RegexTranslator.subCategoryCharClasses[sci] = JDK15RegexTranslator.computeSubCategoryCharClass("LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".substring(sci * 2, (sci + 1) * 2));
        }
        return subCategoryCharClasses[sci];
    }

    private static CharClass computeCategoryCharClass(char code) {
        ArrayList<CharClass> classes = new ArrayList<CharClass>(5);
        classes.add(new Property(new String(new char[]{code})));
        int ci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(code);
        while (ci >= 0) {
            int[] addRanges = RegexData.CATEGORY_RANGES[ci / 2];
            int i = 0;
            while (i < addRanges.length) {
                classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
                i += 2;
            }
            ci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(code, ci + 1);
        }
        if (code == 'P') {
            classes.add(JDK15RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (code == 'L') {
            classes.add(new SingleChar(1013));
            classes.add(new SingleChar(1012));
        }
        if (code == 'C') {
            classes.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar(1012), new SingleChar(1013)})));
            ArrayList<CharRange> assignedRanges = new ArrayList<CharRange>(5);
            int i = 0;
            while (i < RegexData.CATEGORY_RANGES.length) {
                int j = 0;
                while (j < RegexData.CATEGORY_RANGES[i].length) {
                    assignedRanges.add(new CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                    j += 2;
                }
                ++i;
            }
            classes.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(assignedRanges)));
        }
        if (classes.size() == 1) {
            return (CharClass)classes.get(0);
        }
        return new Union(classes);
    }

    private static CharClass computeSubCategoryCharClass(String name) {
        Property base = new Property(name);
        int sci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(name);
        if (sci < 0) {
            if (name.equals("Cn")) {
                ArrayList<SimpleCharClass> assignedRanges = new ArrayList<SimpleCharClass>(5);
                assignedRanges.add(new SingleChar(1012));
                assignedRanges.add(new SingleChar(1013));
                int i = 0;
                while (i < RegexData.CATEGORY_RANGES.length) {
                    int j = 0;
                    while (j < RegexData.CATEGORY_RANGES[i].length) {
                        assignedRanges.add(new CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                        j += 2;
                    }
                    ++i;
                }
                return new Subtraction(new Union(new CharClass[]{base, new CharRange(65536, 0x10FFFF)}), new Union(assignedRanges));
            }
            if (name.equals("Pi")) {
                return JDK15RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039");
            }
            if (name.equals("Pf")) {
                return JDK15RegexTranslator.makeCharClass("\u00bb\u2019\u201d\u203a");
            }
            return base;
        }
        ArrayList<SimpleCharClass> classes = new ArrayList<SimpleCharClass>(5);
        classes.add(base);
        int[] addRanges = RegexData.CATEGORY_RANGES[sci / 2];
        int i = 0;
        while (i < addRanges.length) {
            classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
            i += 2;
        }
        if (name.equals("Lu")) {
            classes.add(new SingleChar(1012));
        } else if (name.equals("Ll")) {
            classes.add(new SingleChar(1013));
        } else if (name.equals("Nl")) {
            classes.add(new CharRange(5870, 5872));
        } else if (name.equals("No")) {
            return new Subtraction(new Union(classes), new CharRange(5870, 5872));
        }
        return new Union(classes);
    }

    private static CharClass makeCharClass(String members) {
        ArrayList<SingleChar> list = new ArrayList<SingleChar>(5);
        int i = 0;
        int len = members.length();
        while (i < len) {
            list.add(new SingleChar(members.charAt(i)));
            ++i;
        }
        return new Union(list);
    }

    public static void main(String[] args) throws RegexSyntaxException {
        String s = JDK15RegexTranslator.translate(args[0], 11, args[1].equals("xpath"), false, true);
        System.err.println(StringValue.diagnosticDisplay(s));
        try {
            Pattern.compile(s);
        }
        catch (Exception err) {
            System.err.println("Error: " + err.getMessage());
        }
        System.err.println();
    }

    static class BackReference
    extends CharClass {
        private final int i;

        BackReference(int i) {
            this.i = i;
        }

        @Override
        void output(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        void inClassOutput(FastStringBuffer buf) {
            if (this.i != -1) {
                buf.append("(?:\\" + this.i + ")");
            } else {
                buf.append("(?:)");
            }
        }
    }

    static abstract class CharClass {
        protected CharClass() {
        }

        abstract void output(FastStringBuffer var1);

        abstract void outputComplement(FastStringBuffer var1);

        int getSingleChar() {
            return -1;
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        void inClassOutput(FastStringBuffer buf) {
            if (JDK15RegexTranslator.isJavaMetaChar(this.lower)) {
                buf.append('\\');
            }
            buf.appendWideChar(this.lower);
            buf.append('-');
            if (JDK15RegexTranslator.isJavaMetaChar(this.upper)) {
                buf.append('\\');
            }
            buf.appendWideChar(this.upper);
        }
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass cc) {
            this.cc = cc;
        }

        @Override
        void output(FastStringBuffer buf) {
            this.cc.outputComplement(buf);
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            this.cc.output(buf);
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
        }

        static Empty getInstance() {
            return instance;
        }

        @Override
        void output(FastStringBuffer buf) {
            buf.append("\\x00");
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            buf.append("[^\\x00]");
        }

        @Override
        void inClassOutput(FastStringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String name) {
            this.name = name;
        }

        @Override
        void inClassOutput(FastStringBuffer buf) {
            buf.append("\\p{");
            buf.append(this.name);
            buf.append('}');
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            buf.append("\\P{");
            buf.append(this.name);
            buf.append('}');
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass() {
        }

        @Override
        void output(FastStringBuffer buf) {
            buf.append('[');
            this.inClassOutput(buf);
            buf.append(']');
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            buf.append("[^");
            this.inClassOutput(buf);
            buf.append(']');
        }

        abstract void inClassOutput(FastStringBuffer var1);
    }

    static class SingleChar
    extends SimpleCharClass {
        private final int c;
        private boolean isEscaped = false;

        SingleChar(int c) {
            this.c = c;
        }

        SingleChar(int c, boolean isEscaped) {
            this.c = c;
            this.isEscaped = isEscaped;
        }

        @Override
        int getSingleChar() {
            return this.c;
        }

        @Override
        void output(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        @Override
        void inClassOutput(FastStringBuffer buf) {
            if (JDK15RegexTranslator.isJavaMetaChar(this.c)) {
                buf.append('\\');
                buf.append((char)this.c);
            } else {
                switch (this.c) {
                    case 13: {
                        buf.append("\\r");
                        break;
                    }
                    case 10: {
                        buf.append("\\n");
                        break;
                    }
                    case 9: {
                        buf.append("\\t");
                        break;
                    }
                    case 32: {
                        buf.append("\\x20");
                        break;
                    }
                    default: {
                        buf.appendWideChar(this.c);
                    }
                }
            }
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass cc1, CharClass cc2) {
            this.cc1 = cc1;
            this.cc2 = cc2;
        }

        @Override
        void output(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.output(buf);
            buf.append("&&");
            this.cc2.outputComplement(buf);
            buf.append(']');
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.outputComplement(buf);
            this.cc2.output(buf);
            buf.append(']');
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] v) {
            this(Union.toList(v));
        }

        private static List toList(CharClass[] v) {
            ArrayList<CharClass> members = new ArrayList<CharClass>(5);
            int i = 0;
            while (i < v.length) {
                members.add(v[i]);
                ++i;
            }
            return members;
        }

        Union(List members) {
            this.members = members;
        }

        @Override
        void output(FastStringBuffer buf) {
            buf.append('[');
            int i = 0;
            int len = this.members.size();
            while (i < len) {
                CharClass cc = (CharClass)this.members.get(i);
                cc.output(buf);
                ++i;
            }
            buf.append(']');
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            CharClass cc;
            boolean first = true;
            int len = this.members.size();
            int i = 0;
            while (i < len) {
                cc = (CharClass)this.members.get(i);
                if (cc instanceof SimpleCharClass) {
                    if (first) {
                        buf.append("[^");
                        first = false;
                    }
                    ((SimpleCharClass)cc).inClassOutput(buf);
                }
                ++i;
            }
            i = 0;
            while (i < len) {
                cc = (CharClass)this.members.get(i);
                if (!(cc instanceof SimpleCharClass)) {
                    if (first) {
                        buf.append('[');
                        first = false;
                    } else {
                        buf.append("&&");
                    }
                    cc.outputComplement(buf);
                }
                ++i;
            }
            if (first) {
                buf.append("[\u0001-");
                buf.appendWideChar(0x10FFFF);
                buf.append("]");
            } else {
                buf.append(']');
            }
        }
    }
}

