/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.functions.ResolveURI;
import net2.sf.saxon.query.ModuleURIResolver;
import net2.sf.saxon.trans.XPathException;

public class StandardModuleURIResolver
implements ModuleURIResolver {
    private static StandardModuleURIResolver THE_INSTANCE = new StandardModuleURIResolver();

    public static StandardModuleURIResolver getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        if (locations.length == 0) {
            XPathException err = new XPathException("Cannot locate module for namespace " + moduleURI);
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        StreamSource[] sources = new StreamSource[locations.length];
        int m = 0;
        while (m < locations.length) {
            URI absoluteURI;
            String href = locations[m];
            try {
                absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
            }
            catch (URISyntaxException err) {
                XPathException se = new XPathException("Cannot resolve relative URI " + href, err);
                se.setErrorCode("XQST0059");
                se.setIsStaticError(true);
                throw se;
            }
            sources[m] = this.getQuerySource(absoluteURI);
            ++m;
        }
        return sources;
    }

    protected StreamSource getQuerySource(URI absoluteURI) throws XPathException {
        try {
            int pos;
            String contentType;
            URL absoluteURL = absoluteURI.toURL();
            URLConnection connection = absoluteURL.openConnection();
            connection.connect();
            InputStream is = connection.getInputStream();
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            String encoding = null;
            if (!"file".equals(connection.getURL().getProtocol()) && (contentType = connection.getContentType()) != null && (pos = contentType.indexOf("charset")) >= 0) {
                if ((pos = contentType.indexOf(61, pos + 7)) >= 0) {
                    contentType = contentType.substring(pos + 1);
                }
                if ((pos = contentType.indexOf(59)) > 0) {
                    contentType = contentType.substring(0, pos);
                }
                if ((pos = contentType.indexOf(40)) > 0) {
                    contentType = contentType.substring(0, pos);
                }
                if ((pos = contentType.indexOf(34)) > 0) {
                    contentType = contentType.substring(pos + 1, contentType.indexOf(34, pos + 2));
                }
                encoding = contentType.trim();
            }
            StreamSource ss = new StreamSource();
            if (encoding == null) {
                ss.setInputStream(is);
            } else {
                ss.setReader(new InputStreamReader(is, encoding));
            }
            ss.setSystemId(absoluteURL.toString());
            return ss;
        }
        catch (IOException err) {
            XPathException se = new XPathException(err);
            se.setErrorCode("XQST0059");
            se.setIsStaticError(true);
            throw se;
        }
    }
}

