/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.query;

import java.util.HashSet;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.functions.FunctionLibrary;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.query.QueryModule;
import net2.sf.saxon.query.XQueryFunction;
import net2.sf.saxon.query.XQueryFunctionBinder;
import net2.sf.saxon.query.XQueryFunctionLibrary;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    transient QueryModule importingModule;
    XQueryFunctionLibrary baseLibrary;
    HashSet namespaces = new HashSet(5);

    public ImportedFunctionLibrary(QueryModule importingModule, XQueryFunctionLibrary baseLibrary) {
        this.importingModule = importingModule;
        this.baseLibrary = baseLibrary;
    }

    public void addImportedNamespace(String namespace) {
        this.namespaces.add(namespace);
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        String uri = functionName.getNamespaceURI();
        if (this.namespaces.contains(uri)) {
            Expression call = this.baseLibrary.bind(functionName, staticArgs, env);
            if (call != null) {
                XQueryFunction def = this.baseLibrary.getDeclaration(functionName, staticArgs);
                this.importingModule.checkImportedFunctionSignature(def);
            }
            return call;
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        if (this.namespaces.contains(functionName.getNamespaceURI())) {
            return this.baseLibrary.getDeclaration(functionName, staticArgs);
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        ImportedFunctionLibrary lib = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        for (String ns : this.namespaces) {
            lib.addImportedNamespace(ns);
        }
        return lib;
    }

    public void setImportingModule(QueryModule importingModule) {
        this.importingModule = importingModule;
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (this.namespaces.contains(functionName.getNamespaceURI())) {
            return this.baseLibrary.getFunctionSignature(functionName, arity);
        }
        return null;
    }
}

