/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net2.sf.saxon.expr.BindingReference;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.VariableDeclaration;
import net2.sf.saxon.expr.VariableReference;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.GlobalParam;
import net2.sf.saxon.instruct.GlobalVariable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.query.Declaration;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Value;

public class GlobalVariableDefinition
implements VariableDeclaration,
Declaration {
    protected List references = new ArrayList(10);
    private SequenceType requiredType;
    private Expression value;
    private boolean isParameter;
    private StructuredQName variableName;
    private String systemId;
    private int lineNumber;
    private GlobalVariable compiledVar;

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setVariableQName(StructuredQName qName) {
        this.variableName = qName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setValueExpression(Expression val) {
        this.value = val;
    }

    public Expression getValueExpression() {
        return this.value;
    }

    public void setIsParameter(boolean b) {
        this.isParameter = b;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public Iterator iterateReferences() {
        return this.references.iterator();
    }

    public GlobalVariable compile(Executable exec, int slot) throws XPathException {
        GlobalVariable var;
        TypeHierarchy th = exec.getConfiguration().getTypeHierarchy();
        if (this.isParameter) {
            var = new GlobalParam();
            var.setExecutable(exec);
            var.setRequiredParam(this.value == null);
        } else {
            var = new GlobalVariable();
            var.setExecutable(exec);
        }
        var.setSelectExpression(this.value);
        var.setRequiredType(this.requiredType);
        var.setVariableQName(this.variableName);
        var.setSlotNumber(slot);
        int loc = exec.getLocationMap().allocateLocationId(this.systemId, this.lineNumber);
        var.setLocationId(loc);
        var.setContainer(var);
        SequenceType type = this.getRequiredType();
        for (BindingReference ref : this.references) {
            int relation;
            ref.fixup(var);
            Value constantValue = null;
            int properties = 0;
            Expression select = this.value;
            if (select instanceof Literal && !this.isParameter && ((relation = th.relationship(select.getItemType(th), type.getPrimaryType())) == 0 || relation == 2)) {
                constantValue = ((Literal)select).getValue();
            }
            if (select != null) {
                properties = select.getSpecialProperties();
            }
            ref.setStaticType(type, constantValue, properties |= 0x400000);
        }
        exec.registerGlobalVariable(var);
        var.setReferenceCount(10);
        this.compiledVar = var;
        return var;
    }

    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        GlobalVariable var = this.getCompiledVariable();
        Expression value = var.getSelectExpression();
        if (value != null) {
            value.checkForUpdatingSubexpressions();
            if (value.isUpdatingExpression()) {
                throw new XPathException("Initializing expression for global variable must not be an updating expression", "XUST0001");
            }
            value.setContainer(var);
            RoleLocator role = new RoleLocator(3, var.getVariableQName(), 0);
            Expression value2 = TypeChecker.strictTypeCheck(visitor.typeCheck(visitor.simplify(value), AnyItemType.getInstance()), var.getRequiredType(), role, visitor.getStaticContext());
            value2 = value2.optimize(visitor, AnyItemType.getInstance());
            var.setSelectExpression(value2);
            value2.setContainer(var);
            SlotManager map = visitor.getConfiguration().makeSlotManager();
            int slots = ExpressionTool.allocateSlots(value2, 0, map);
            if (slots > 0) {
                var.setContainsLocals(map);
            }
            if (var.getRequiredType() == SequenceType.ANY_SEQUENCE && !(var instanceof GlobalParam)) {
                try {
                    TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
                    ItemType itemType = value.getItemType(th);
                    int cardinality = value.getCardinality();
                    var.setRequiredType(SequenceType.makeSequenceType(itemType, cardinality));
                    Value constantValue = null;
                    if (value2 instanceof Literal) {
                        constantValue = ((Literal)value2).getValue();
                    }
                    for (BindingReference ref : this.references) {
                        if (!(ref instanceof VariableReference)) continue;
                        ((VariableReference)ref).refineVariableType(itemType, cardinality, constantValue, value.getSpecialProperties(), visitor);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public GlobalVariable getCompiledVariable() {
        return this.compiledVar;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("declareVariable");
        out.emitAttribute("name", this.variableName.getDisplayName());
        if (this.value != null) {
            this.value.explain(out);
        }
        out.endElement();
    }
}

