/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.LocationProvider;
import net2.sf.saxon.event.NamespaceReducer;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.SaxonLocator;
import net2.sf.saxon.event.SourceLocationProvider;
import net2.sf.saxon.event.XMLEmitter;
import net2.sf.saxon.expr.ExpressionLocation;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceDeclarations;
import net2.sf.saxon.pull.PullProvider;
import net2.sf.saxon.pull.PullPushCopier;
import net2.sf.saxon.pull.UnparsedEntity;
import net2.sf.saxon.tinytree.CharSlice;
import net2.sf.saxon.tinytree.CompressedWhitespace;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Whitespace;

public class StaxBridge
implements PullProvider,
SaxonLocator,
SourceLocationProvider {
    private XMLStreamReader reader;
    private StaxAttributes attributes = new StaxAttributes();
    private StaxNamespaces namespaces = new StaxNamespaces();
    private PipelineConfiguration pipe;
    private List unparsedEntities = null;
    int currentEvent = 0;
    int depth = 0;
    boolean ignoreIgnorable = false;

    public void setInputStream(String systemId, InputStream inputStream) throws XPathException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setXMLReporter(new StaxErrorReporter());
            this.reader = factory.createXMLStreamReader(systemId, inputStream);
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void setXMLStreamReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = new PipelineConfiguration(pipe);
        this.pipe.setLocationProvider(this);
        this.ignoreIgnorable = pipe.getConfiguration().getStripsWhiteSpace() != 0;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    @Override
    public int next() throws XPathException {
        if (this.currentEvent == 0) {
            this.currentEvent = 2;
            return this.currentEvent;
        }
        if (this.currentEvent == -1 || this.currentEvent == 3) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            return -1;
        }
        try {
            if (this.reader.hasNext()) {
                int event = this.reader.next();
                this.currentEvent = this.translate(event);
            } else {
                this.currentEvent = -1;
            }
        }
        catch (XMLStreamException e) {
            int c;
            String message = e.getMessage();
            if (message.startsWith("ParseError at") && (c = message.indexOf("\nMessage: ")) > 0) {
                message = message.substring(c + 10);
            }
            XPathException err = new XPathException("Error reported by XML parser: " + message);
            err.setErrorCode("SXXP0003");
            err.setLocator(this.translateLocation(e.getLocation()));
            throw err;
        }
        return this.currentEvent;
    }

    private int translate(int event) throws XPathException {
        switch (event) {
            case 10: {
                return 6;
            }
            case 12: {
                return 8;
            }
            case 4: {
                if (this.depth == 0 && this.reader.isWhiteSpace()) {
                    return this.next();
                }
                return 8;
            }
            case 5: {
                return 9;
            }
            case 11: {
                this.unparsedEntities = (List)this.reader.getProperty("javax.xml.stream.entities");
                return this.next();
            }
            case 8: {
                return 3;
            }
            case 2: {
                --this.depth;
                return 5;
            }
            case 15: {
                return this.next();
            }
            case 9: {
                return this.next();
            }
            case 13: {
                return 7;
            }
            case 14: {
                return this.next();
            }
            case 3: {
                return 10;
            }
            case 6: {
                if (this.depth == 0) {
                    return this.next();
                }
                if (this.ignoreIgnorable) {
                    return this.next();
                }
                return 8;
            }
            case 7: {
                return this.next();
            }
            case 1: {
                ++this.depth;
                return 4;
            }
        }
        throw new IllegalStateException("Unknown StAX event " + event);
    }

    @Override
    public int current() {
        return this.currentEvent;
    }

    @Override
    public AttributeCollection getAttributes() throws XPathException {
        return this.attributes;
    }

    @Override
    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        return this.namespaces;
    }

    @Override
    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                try {
                    int skipDepth = 0;
                    while (this.reader.hasNext()) {
                        int event = this.reader.next();
                        if (event == 1) {
                            ++skipDepth;
                            continue;
                        }
                        if (event != 2 || skipDepth-- != 0) continue;
                        this.currentEvent = 5;
                        return this.currentEvent;
                    }
                }
                catch (XMLStreamException e) {
                    throw new XPathException(e);
                }
                throw new IllegalStateException("Element start has no matching element end");
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    @Override
    public int getNameCode() {
        if (this.currentEvent == 4 || this.currentEvent == 5) {
            String local = this.reader.getLocalName();
            String uri = this.reader.getNamespaceURI();
            String prefix = this.reader.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            return this.getNamePool().allocate(prefix, uri, local);
        }
        if (this.currentEvent == 10) {
            String local = this.reader.getPITarget();
            return this.getNamePool().allocate("", "", local);
        }
        throw new IllegalStateException();
    }

    @Override
    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getStringValue() throws XPathException {
        switch (this.currentEvent) {
            case 8: {
                CharSlice cs = new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                return CompressedWhitespace.compress(cs);
            }
            case 9: {
                return new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            }
            case 10: {
                String s = this.reader.getPIData();
                return Whitespace.removeLeadingWhitespace(s);
            }
            case 4: {
                FastStringBuffer combinedText = null;
                try {
                    int depth = 0;
                    while (true) {
                        if (!this.reader.hasNext()) {
                            throw new IllegalStateException("getStringValue() called when current event is " + this.currentEvent);
                        }
                        int event = this.reader.next();
                        if (event == 4) {
                            if (combinedText == null) {
                                combinedText = new FastStringBuffer(64);
                            }
                            combinedText.append(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                            continue;
                        }
                        if (event == 1) {
                            ++depth;
                            continue;
                        }
                        if (event == 2 && depth-- == 0) break;
                    }
                    this.currentEvent = 5;
                    if (combinedText == null) return "";
                    return combinedText.condense();
                }
                catch (XMLStreamException e) {
                    throw new XPathException(e);
                }
            }
        }
        throw new IllegalStateException("getStringValue() called when current event is " + this.currentEvent);
    }

    @Override
    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public int getLocationId() {
        return 0;
    }

    @Override
    public int getTypeAnnotation() {
        return -1;
    }

    @Override
    public SourceLocator getSourceLocator() {
        return this.translateLocation(this.reader.getLocation());
    }

    private ExpressionLocation translateLocation(Location location) {
        ExpressionLocation loc = new ExpressionLocation();
        if (location != null) {
            loc.setLineNumber(location.getLineNumber());
            loc.setColumnNumber(location.getColumnNumber());
            loc.setSystemId(location.getSystemId());
        }
        return loc;
    }

    @Override
    public String getPublicId() {
        return this.reader.getLocation().getPublicId();
    }

    @Override
    public String getSystemId() {
        Location location = this.reader.getLocation();
        return location == null ? null : location.getSystemId();
    }

    @Override
    public int getLineNumber() {
        Location location = this.reader.getLocation();
        return location == null ? -1 : location.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.reader.getLocation().getColumnNumber();
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return this.getColumnNumber();
    }

    @Override
    public List getUnparsedEntities() {
        if (this.unparsedEntities == null) {
            return null;
        }
        ArrayList<UnparsedEntity> list = new ArrayList<UnparsedEntity>(this.unparsedEntities.size());
        int i = 0;
        while (i < this.unparsedEntities.size()) {
            Object ent = this.unparsedEntities.get(i);
            String name = null;
            String systemId = null;
            String publicId = null;
            String baseURI = null;
            if (ent instanceof EntityDeclaration) {
                EntityDeclaration ed = (EntityDeclaration)ent;
                name = ed.getName();
                systemId = ed.getSystemId();
                publicId = ed.getPublicId();
                baseURI = ed.getBaseURI();
            } else if (ent.getClass().getName().equals("com.ctc.wstx.ent.UnparsedExtEntity")) {
                try {
                    Class<?> woodstoxClass = ent.getClass();
                    Object[] noArgs = new Class[]{};
                    Method method = woodstoxClass.getMethod("getName", (Class<?>[])noArgs);
                    name = (String)method.invoke(ent, noArgs);
                    method = woodstoxClass.getMethod("getSystemId", (Class<?>[])noArgs);
                    systemId = (String)method.invoke(ent, noArgs);
                    method = woodstoxClass.getMethod("getPublicId", (Class<?>[])noArgs);
                    publicId = (String)method.invoke(ent, noArgs);
                    method = woodstoxClass.getMethod("getBaseURI", (Class<?>[])noArgs);
                    baseURI = (String)method.invoke(ent, noArgs);
                }
                catch (NoSuchMethodException woodstoxClass) {
                }
                catch (IllegalAccessException woodstoxClass) {
                }
                catch (InvocationTargetException woodstoxClass) {
                    // empty catch block
                }
            }
            if (name != null) {
                if (baseURI != null) {
                    try {
                        systemId = new URI(baseURI).resolve(systemId).toString();
                    }
                    catch (URISyntaxException woodstoxClass) {
                        // empty catch block
                    }
                }
                UnparsedEntity ue = new UnparsedEntity();
                ue.setName(name);
                ue.setSystemId(systemId);
                ue.setPublicId(publicId);
                ue.setBaseURI(baseURI);
                list.add(ue);
            }
            ++i;
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 1) {
            long startTime = System.currentTimeMillis();
            PipelineConfiguration pipe = new Configuration().makePipelineConfiguration();
            StaxBridge puller = new StaxBridge();
            File f = new File(args[0]);
            puller.setInputStream(f.toURI().toString(), new FileInputStream(f));
            XMLEmitter emitter = new XMLEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setOutputProperties(new Properties());
            if (args.length > 1) {
                emitter.setOutputStream(new FileOutputStream(args[1]));
            } else {
                emitter.setOutputStream(System.out);
            }
            NamespaceReducer r = new NamespaceReducer();
            r.setUnderlyingReceiver(emitter);
            puller.setPipelineConfiguration(pipe);
            r.setPipelineConfiguration(pipe);
            new PullPushCopier(puller, r).copy();
            System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
            ++i;
        }
    }

    private class StaxAttributes
    implements AttributeCollection {
        private StaxAttributes() {
        }

        public void setLocationProvider(LocationProvider provider) {
        }

        @Override
        public int getLength() {
            return StaxBridge.this.reader.getAttributeCount();
        }

        @Override
        public int getNameCode(int index) {
            String local = StaxBridge.this.reader.getAttributeLocalName(index);
            String uri = StaxBridge.this.reader.getAttributeNamespace(index);
            String prefix = StaxBridge.this.reader.getAttributePrefix(index);
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            return StaxBridge.this.getNamePool().allocate(prefix, uri, local);
        }

        @Override
        public int getTypeAnnotation(int index) {
            String type = StaxBridge.this.reader.getAttributeType(index);
            if ("ID".equals(type)) {
                return 1073742384;
            }
            return 631;
        }

        @Override
        public int getLocationId(int index) {
            return 0;
        }

        @Override
        public String getSystemId(int index) {
            return StaxBridge.this.reader.getLocation().getSystemId();
        }

        @Override
        public int getLineNumber(int index) {
            return StaxBridge.this.reader.getLocation().getLineNumber();
        }

        @Override
        public int getProperties(int index) {
            int properties = 0;
            if (!StaxBridge.this.reader.isAttributeSpecified(index)) {
                properties |= 8;
            }
            if (this.isIdref(index)) {
                properties |= 0x3000;
            }
            return properties;
        }

        @Override
        public String getPrefix(int index) {
            return StaxBridge.this.getNamePool().getPrefix(this.getNameCode(index));
        }

        @Override
        public String getQName(int index) {
            return StaxBridge.this.getNamePool().getDisplayName(this.getNameCode(index));
        }

        @Override
        public String getLocalName(int index) {
            return StaxBridge.this.reader.getAttributeLocalName(index);
        }

        @Override
        public String getURI(int index) {
            return StaxBridge.this.reader.getAttributeNamespace(index);
        }

        @Override
        public int getIndex(String uri, String localname) {
            int i = 0;
            while (i < this.getLength()) {
                if (this.getLocalName(i).equals(localname) && this.getURI(i).equals(uri)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getIndexByFingerprint(int fingerprint) {
            return this.getIndex(StaxBridge.this.getNamePool().getURI(fingerprint), StaxBridge.this.getNamePool().getLocalName(fingerprint));
        }

        @Override
        public String getValueByFingerprint(int fingerprint) {
            return this.getValue(this.getIndexByFingerprint(fingerprint));
        }

        @Override
        public String getValue(String uri, String localname) {
            return StaxBridge.this.reader.getAttributeValue(uri, localname);
        }

        @Override
        public String getValue(int index) {
            return StaxBridge.this.reader.getAttributeValue(index);
        }

        @Override
        public boolean isId(int index) {
            return "ID".equals(StaxBridge.this.reader.getAttributeType(index));
        }

        @Override
        public boolean isIdref(int index) {
            String attributeType = StaxBridge.this.reader.getAttributeType(index);
            return "IDREF".equals(attributeType) || "IDREFS".equals(attributeType);
        }
    }

    private class StaxErrorReporter
    implements XMLReporter {
        private StaxErrorReporter() {
        }

        @Override
        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
            ExpressionLocation loc = StaxBridge.this.translateLocation(location);
            XPathException err = new XPathException("Error reported by XML parser: " + message + " (" + errorType + ')');
            err.setLocator(loc);
            try {
                StaxBridge.this.pipe.getErrorListener().error(err);
            }
            catch (TransformerException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public class StaxNamespaces
    implements NamespaceDeclarations {
        @Override
        public int getNumberOfNamespaces() {
            return StaxBridge.this.reader.getNamespaceCount();
        }

        @Override
        public String getPrefix(int index) {
            String p = StaxBridge.this.reader.getNamespacePrefix(index);
            return p == null ? "" : p;
        }

        @Override
        public String getURI(int index) {
            String uri = StaxBridge.this.reader.getNamespaceURI(index);
            return uri == null ? "" : uri;
        }

        @Override
        public int getNamespaceCode(int index) {
            return StaxBridge.this.getNamePool().allocateNamespaceCode(this.getPrefix(index), this.getURI(index));
        }

        @Override
        public int[] getNamespaceCodes(int[] buffer) {
            if (buffer.length < this.getNumberOfNamespaces()) {
                buffer = new int[this.getNumberOfNamespaces()];
            }
            int i = 0;
            while (i < this.getNumberOfNamespaces()) {
                buffer[i] = this.getNamespaceCode(i);
                ++i;
            }
            return buffer;
        }
    }
}

