/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pull;

import java.util.List;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.NamespaceDeclarations;
import net2.sf.saxon.om.Orphan;
import net2.sf.saxon.pull.PullFilter;
import net2.sf.saxon.pull.PullProvider;
import net2.sf.saxon.pull.UnparsedEntity;
import net2.sf.saxon.trans.XPathException;

public class PullPushTee
extends PullFilter {
    private Receiver branch;
    boolean previousAtomic = false;

    public PullPushTee(PullProvider base, Receiver branch) throws XPathException {
        super(base);
        this.branch = branch;
    }

    public Receiver getReceiver() {
        return this.branch;
    }

    @Override
    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.copyEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void copyEvent(int event) throws XPathException {
        PullProvider in = this.getUnderlyingProvider();
        Receiver out = this.branch;
        switch (event) {
            case 2: {
                out.startDocument(0);
                break;
            }
            case 4: {
                out.startElement(in.getNameCode(), in.getTypeAnnotation(), 0, 0);
                NamespaceDeclarations decl = in.getNamespaceDeclarations();
                int i = 0;
                while (i < decl.getNumberOfNamespaces()) {
                    out.namespace(decl.getNamespaceCode(i), 0);
                    ++i;
                }
                AttributeCollection atts = in.getAttributes();
                int i2 = 0;
                while (i2 < atts.getLength()) {
                    out.attribute(atts.getNameCode(i2), atts.getTypeAnnotation(i2), atts.getValue(i2), 0, atts.getProperties(i2));
                    ++i2;
                }
                out.startContent();
                break;
            }
            case 8: {
                out.characters(in.getStringValue(), 0, 0);
                break;
            }
            case 9: {
                out.comment(in.getStringValue(), 0, 0);
                break;
            }
            case 10: {
                out.processingInstruction(in.getPipelineConfiguration().getConfiguration().getNamePool().getLocalName(in.getNameCode()), in.getStringValue(), 0, 0);
                break;
            }
            case 5: {
                out.endElement();
                break;
            }
            case 3: {
                List entities = in.getUnparsedEntities();
                if (entities != null) {
                    int i = 0;
                    while (i < entities.size()) {
                        UnparsedEntity ue = (UnparsedEntity)entities.get(i);
                        out.setUnparsedEntity(ue.getName(), ue.getSystemId(), ue.getPublicId());
                        ++i;
                    }
                }
                out.endDocument();
                break;
            }
            case -1: {
                in.close();
                break;
            }
            case 1: {
                if (out instanceof SequenceReceiver) {
                    ((SequenceReceiver)out).append(super.getAtomicValue(), 0, 0);
                    break;
                }
                if (this.previousAtomic) {
                    out.characters(" ", 0, 0);
                }
                CharSequence chars = in.getStringValue();
                out.characters(chars, 0, 0);
                break;
            }
            case 6: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNameCode(this.getNameCode());
                    o.setNodeKind((short)2);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, 0, 0);
                    break;
                }
                out.attribute(this.getNameCode(), this.getTypeAnnotation(), this.getStringValue(), 0, 0);
                break;
            }
            case 7: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNameCode(this.getNameCode());
                    o.setNodeKind((short)13);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, 0, 0);
                    break;
                }
                int nsCode = this.getNamePool().getNamespaceCode(this.getNameCode());
                out.namespace(nsCode, 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + event);
            }
        }
        this.previousAtomic = event == 1;
    }
}

