/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pattern;

import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.sort.IntHashSet;
import net2.sf.saxon.tinytree.TinyTree;

public class SubstitutionGroupTest
extends NodeTest {
    private int head;
    private IntHashSet group;

    public SubstitutionGroupTest(int head, IntHashSet group) {
        this.group = group;
        this.head = head;
    }

    public SubstitutionGroupTest(int head, int[] members) {
        this.group = new IntHashSet(members.length);
        int i = 0;
        while (i < members.length) {
            this.group.add(members[i]);
            ++i;
        }
        this.head = head;
    }

    @Override
    public boolean matches(int nodeKind, int nameCode, int annotation) {
        return nodeKind == 1 && this.group.contains(nameCode & 0xFFFFF);
    }

    @Override
    public boolean matches(TinyTree tree, int nodeNr) {
        return tree.getNodeKind(nodeNr) == 1 && this.group.contains(tree.getNameCode(nodeNr) & 0xFFFFF);
    }

    @Override
    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == 1 && this.group.contains(node.getFingerprint());
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getPrimitiveType() {
        return 1;
    }

    @Override
    public int getNodeKindMask() {
        return 2;
    }

    @Override
    public IntHashSet getRequiredNodeNames() {
        return this.group;
    }

    public int getHeadFingerprint() {
        return this.head;
    }

    @Override
    public String toString(NamePool pool) {
        return "schema-element(" + pool.getDisplayName(this.head) + ')';
    }

    public int hashCode() {
        return this.head;
    }

    public boolean equals(Object other) {
        return other instanceof SubstitutionGroupTest && ((SubstitutionGroupTest)other).head == this.head;
    }
}

