/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pattern;

import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.type.AnySimpleType;
import net2.sf.saxon.type.AnyType;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.SchemaType;

public class NodeKindTest
extends NodeTest {
    public static final NodeKindTest DOCUMENT = new NodeKindTest(9);
    public static final NodeKindTest ELEMENT = new NodeKindTest(1);
    public static final NodeKindTest ATTRIBUTE = new NodeKindTest(2);
    public static final NodeKindTest TEXT = new NodeKindTest(3);
    public static final NodeKindTest COMMENT = new NodeKindTest(8);
    public static final NodeKindTest PROCESSING_INSTRUCTION = new NodeKindTest(7);
    public static final NodeKindTest NAMESPACE = new NodeKindTest(13);
    private int kind;

    private NodeKindTest(int nodeKind) {
        this.kind = nodeKind;
    }

    public static NodeTest makeNodeKindTest(int kind) {
        switch (kind) {
            case 9: {
                return DOCUMENT;
            }
            case 1: {
                return ELEMENT;
            }
            case 2: {
                return ATTRIBUTE;
            }
            case 8: {
                return COMMENT;
            }
            case 3: {
                return TEXT;
            }
            case 7: {
                return PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NAMESPACE;
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown node kind in NodeKindTest");
    }

    @Override
    public boolean matches(int nodeKind, int fingerprint, int annotation) {
        return this.kind == nodeKind;
    }

    @Override
    public boolean matches(TinyTree tree, int nodeNr) {
        return tree.getNodeKind(nodeNr) == this.kind;
    }

    @Override
    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == this.kind;
    }

    @Override
    public final double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public int getPrimitiveType() {
        return this.kind;
    }

    @Override
    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    @Override
    public SchemaType getContentType() {
        switch (this.kind) {
            case 9: {
                return AnyType.getInstance();
            }
            case 1: {
                return AnyType.getInstance();
            }
            case 2: {
                return AnySimpleType.getInstance();
            }
            case 8: {
                return BuiltInAtomicType.STRING;
            }
            case 3: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 7: {
                return BuiltInAtomicType.STRING;
            }
            case 13: {
                return BuiltInAtomicType.STRING;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    @Override
    public AtomicType getAtomizedItemType() {
        switch (this.kind) {
            case 9: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 1: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            case 2: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
            case 8: {
                return BuiltInAtomicType.STRING;
            }
            case 3: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 7: {
                return BuiltInAtomicType.STRING;
            }
            case 13: {
                return BuiltInAtomicType.STRING;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    public String toString() {
        return NodeKindTest.toString(this.kind);
    }

    public static String toString(int kind) {
        switch (kind) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "element()";
            }
            case 2: {
                return "attribute()";
            }
            case 8: {
                return "comment()";
            }
            case 3: {
                return "text()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 13: {
                return "namespace()";
            }
        }
        return "** error **";
    }

    public static String nodeKindName(int kind) {
        switch (kind) {
            case 9: {
                return "document";
            }
            case 1: {
                return "element";
            }
            case 2: {
                return "attribute";
            }
            case 8: {
                return "comment";
            }
            case 3: {
                return "text";
            }
            case 7: {
                return "processing-instruction";
            }
            case 13: {
                return "namespace";
            }
        }
        return "** error **";
    }

    public int hashCode() {
        return this.kind;
    }

    public boolean equals(Object other) {
        return other instanceof NodeKindTest && ((NodeKindTest)other).kind == this.kind;
    }
}

