/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pattern;

import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.pattern.QNameTest;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public final class NamespaceTest
extends NodeTest
implements QNameTest {
    private NamePool namePool;
    private int nodeKind;
    private short uriCode;
    private String uri;

    public NamespaceTest(NamePool pool, int nodeKind, String uri) {
        this.namePool = pool;
        this.nodeKind = nodeKind;
        this.uri = uri;
        this.uriCode = pool.allocateCodeForURI(uri);
    }

    @Override
    public boolean matches(int nodeType, int fingerprint, int annotation) {
        return fingerprint != -1 && nodeType == this.nodeKind && this.uriCode == this.namePool.getURICode(fingerprint);
    }

    @Override
    public boolean matches(TinyTree tree, int nodeNr) {
        int fingerprint = tree.getNameCode(nodeNr) & 0xFFFFF;
        return fingerprint != -1 && tree.getNodeKind(nodeNr) == this.nodeKind && this.uriCode == this.namePool.getURICode(fingerprint);
    }

    @Override
    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == this.nodeKind && node.getURI().equals(this.uri);
    }

    @Override
    public boolean matches(StructuredQName qname) {
        return qname.getNamespaceURI().equals(this.uri);
    }

    @Override
    public final double getDefaultPriority() {
        return -0.25;
    }

    @Override
    public int getPrimitiveType() {
        return this.nodeKind;
    }

    @Override
    public ItemType getSuperType(TypeHierarchy th) {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    @Override
    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String getNamespaceURI() {
        return this.namePool.getURIFromURICode(this.uriCode);
    }

    public String toString() {
        return String.valueOf('{') + this.namePool.getURIFromURICode(this.uriCode) + "}:*";
    }

    public int hashCode() {
        return this.uriCode << 5 + this.nodeKind;
    }

    public boolean equals(Object other) {
        return other instanceof NamespaceTest && ((NamespaceTest)other).namePool == this.namePool && ((NamespaceTest)other).nodeKind == this.nodeKind && ((NamespaceTest)other).uriCode == this.uriCode;
    }
}

