/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pattern;

import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.MonoIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.pattern.Pattern;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.SequenceType;

public final class IDPattern
extends Pattern {
    private Expression idExpression;

    public IDPattern(Expression id) {
        this.idExpression = id;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.idExpression = visitor.typeCheck(this.idExpression, contextItemType);
        RoleLocator role = new RoleLocator(0, (Serializable)((Object)"id"), 1);
        this.idExpression = TypeChecker.staticTypeCheck(this.idExpression, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
        return this;
    }

    @Override
    public int getDependencies() {
        return this.idExpression.getDependencies();
    }

    @Override
    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.idExpression);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.idExpression = this.idExpression.promote(offer, parent);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (this.idExpression == original) {
            this.idExpression = replacement;
            return true;
        }
        return false;
    }

    @Override
    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.idExpression, nextFree, slotManager);
    }

    @Override
    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        if (e.getNodeKind() != 1) {
            return false;
        }
        DocumentInfo doc = e.getDocumentRoot();
        if (doc == null) {
            return false;
        }
        AtomicValue idValue = (AtomicValue)this.idExpression.evaluateItem(context);
        if (idValue == null) {
            return false;
        }
        String ids = idValue.getStringValue();
        if (ids.indexOf(32) < 0 && ids.indexOf(9) < 0 && ids.indexOf(10) < 0 && ids.indexOf(12) < 0) {
            NodeInfo element = doc.selectID(ids, false);
            if (element == null) {
                return false;
            }
            return element.isSameNodeInfo(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(ids, " \t\n\r", false);
        while (tokenizer.hasMoreElements()) {
            String id = (String)tokenizer.nextElement();
            NodeInfo element = doc.selectID(id, false);
            if (element == null || !e.isSameNodeInfo(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNodeKind() {
        return 1;
    }

    @Override
    public NodeTest getNodeTest() {
        return NodeKindTest.ELEMENT;
    }

    public boolean equals(Object other) {
        return other instanceof IDPattern && ((IDPattern)other).idExpression.equals(this.idExpression);
    }

    public int hashCode() {
        return 0x73108728 ^ this.idExpression.hashCode();
    }
}

