/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.pattern;

import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.tinytree.TinyTree;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest elementTest) {
        this.elementTest = elementTest;
    }

    @Override
    public boolean matches(int nodeKind, int fingerprint, int annotation) {
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    @Override
    public boolean matches(TinyTree tree, int nodeNr) {
        if (tree.getNodeKind(nodeNr) != 9) {
            return false;
        }
        return this.matches(tree.getNode(nodeNr));
    }

    @Override
    public boolean matches(NodeInfo node) {
        if (node.getNodeKind() != 9) {
            return false;
        }
        AxisIterator iter = node.iterateAxis((byte)3);
        boolean found = false;
        while (true) {
            NodeInfo n;
            if ((n = (NodeInfo)iter.next()) == null) {
                return found;
            }
            int kind = n.getNodeKind();
            if (kind == 3) {
                return false;
            }
            if (kind != 1) continue;
            if (found) {
                return false;
            }
            if (!this.elementTest.matches(n)) break;
            found = true;
        }
        return false;
    }

    @Override
    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    @Override
    public int getPrimitiveType() {
        return 9;
    }

    @Override
    public int getNodeKindMask() {
        return 512;
    }

    public NodeTest getElementTest() {
        return this.elementTest;
    }

    @Override
    public String toString(NamePool pool) {
        return "document-node(" + this.elementTest.toString(pool) + ')';
    }

    public String toString() {
        return "document-node(" + this.elementTest.toString() + ')';
    }

    public int hashCode() {
        return this.elementTest.hashCode() ^ 0x3039;
    }

    public boolean equals(Object other) {
        return other instanceof DocumentNodeTest && ((DocumentNodeTest)other).elementTest.equals(this.elementTest);
    }
}

