/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.xom;

import java.util.Stack;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.option.xom.DocumentWrapper;
import net2.sf.saxon.trans.XPathException;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;

public class XOMWriter
extends Builder {
    private Document document;
    private Stack ancestors = new Stack();
    private NodeFactory nodeFactory;
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(64);

    public XOMWriter() {
        this.nodeFactory = new NodeFactory();
    }

    public XOMWriter(NodeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.nodeFactory = factory;
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = this.nodeFactory.startMakingDocument();
        this.document.setBaseURI(this.systemId);
        this.ancestors.push(this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.nodeFactory.finishMakingDocument(this.document);
        this.ancestors.pop();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        Element element;
        this.flush();
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        if (this.ancestors.size() == 1) {
            element = this.nodeFactory.makeRootElement(qname, uri);
            this.document.setRootElement(element);
        } else {
            element = this.nodeFactory.startMakingElement(qname, uri);
        }
        if (element == null) {
            throw new XPathException("XOM node factory returned null");
        }
        this.ancestors.push(element);
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
        String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
        ((Element)this.ancestors.peek()).addNamespaceDeclaration(prefix, uri);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        Nodes nodes = this.nodeFactory.makeAttribute(qname, uri, value.toString(), Attribute.Type.CDATA);
        int n = 0;
        while (n < nodes.size()) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
            } else {
                ((Element)this.ancestors.peek()).appendChild(node);
            }
            ++n;
        }
    }

    @Override
    public void startContent() throws XPathException {
        this.flush();
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        Element element = (Element)this.ancestors.pop();
        Node parent = (Node)this.ancestors.peek();
        Nodes nodes = this.nodeFactory.finishMakingElement(element);
        if (parent == this.document) {
            if (this.implicitDocumentNode) {
                this.endDocument();
            }
        } else {
            int n = 0;
            while (n < nodes.size()) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                } else {
                    ((Element)parent).appendChild(node);
                }
                ++n;
            }
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            Nodes nodes = this.nodeFactory.makeText(this.textBuffer.toString());
            int n = 0;
            while (n < nodes.size()) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                } else {
                    ((Element)this.ancestors.peek()).appendChild(node);
                }
                ++n;
            }
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeProcessingInstruction(target, data.toString());
        int n = 0;
        while (n < nodes.size()) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
            } else {
                ((Element)this.ancestors.peek()).appendChild(node);
            }
            ++n;
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeComment(chars.toString());
        int n = 0;
        while (n < nodes.size()) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
            } else {
                ((Element)this.ancestors.peek()).appendChild(node);
            }
            ++n;
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new DocumentWrapper((Node)this.document, this.systemId, this.config);
    }
}

