/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.xom;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceIterator;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SiblingCountingNode;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.om.VirtualNode;
import net2.sf.saxon.option.xom.DocumentWrapper;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Value;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Node node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Node node, NodeWrapper parent, int index) {
        int kind;
        if (node instanceof Element) {
            kind = 1;
        } else if (node instanceof Text) {
            kind = 3;
        } else if (node instanceof Attribute) {
            kind = 2;
        } else if (node instanceof Comment) {
            kind = 8;
        } else if (node instanceof ProcessingInstruction) {
            kind = 7;
        } else if (node instanceof Document) {
            kind = 9;
        } else {
            NodeWrapper.throwIllegalNode(node);
            return;
        }
        this.nodeKind = (short)kind;
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected final NodeWrapper makeWrapper(Node node, DocumentWrapper docWrapper) {
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected final NodeWrapper makeWrapper(Node node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        if (node == docWrapper.node) {
            return docWrapper;
        }
        NodeWrapper wrapper = new NodeWrapper(node, parent, index);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    private static void throwIllegalNode(Node node) {
        String str = node == null ? "NULL" : node.getClass() + " instance " + node.toString();
        throw new IllegalArgumentException("Bad node type in XOM! " + str);
    }

    @Override
    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    @Override
    public Object getRealNode() {
        return this.getUnderlyingNode();
    }

    @Override
    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((AtomicValue)this.atomize());
    }

    @Override
    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof NodeWrapper && this.node == ((NodeWrapper)other).node;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    @Override
    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof NodeWrapper) {
            return NodeWrapper.compareOrderFast(this.node, ((NodeWrapper)other).node);
        }
        return -other.compareOrder(this);
    }

    private static int compareOrderFast(Node first, Node second) {
        if (first == second) {
            return 0;
        }
        ParentNode firstParent = first.getParent();
        ParentNode secondParent = second.getParent();
        if (firstParent == null) {
            if (secondParent != null) {
                return -1;
            }
            return first.hashCode() - second.hashCode();
        }
        if (secondParent == null) {
            return 1;
        }
        if (firstParent == secondParent) {
            int i1 = firstParent.indexOf(first);
            int i2 = firstParent.indexOf(second);
            if (i1 != -1) {
                return i2 != -1 ? i1 - i2 : 1;
            }
            if (i2 != -1) {
                return -1;
            }
            Element elem = (Element)firstParent;
            int i = elem.getAttributeCount();
            while (--i >= 0) {
                Attribute attr = elem.getAttribute(i);
                if (attr == second) {
                    return -1;
                }
                if (attr != first) continue;
                return 1;
            }
            throw new IllegalStateException("should be unreachable");
        }
        int depth1 = 0;
        int depth2 = 0;
        Node p1 = first;
        Node p2 = second;
        while (p1 != null) {
            ++depth1;
            if ((p1 = p1.getParent()) != second) continue;
            return 1;
        }
        while (p2 != null) {
            ++depth2;
            if ((p2 = p2.getParent()) != first) continue;
            return -1;
        }
        p1 = first;
        while (depth1 > depth2) {
            p1 = p1.getParent();
            --depth1;
        }
        p2 = second;
        while (depth2 > depth1) {
            p2 = p2.getParent();
            --depth2;
        }
        while (true) {
            firstParent = p1.getParent();
            secondParent = p2.getParent();
            if (firstParent == null || secondParent == null) {
                return p1.hashCode() - p2.hashCode();
            }
            if (firstParent == secondParent) {
                return firstParent.indexOf(p1) - firstParent.indexOf(p2);
            }
            p1 = firstParent;
            p2 = secondParent;
        }
    }

    @Override
    public String getStringValue() {
        return this.node.getValue();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.node.getValue();
    }

    @Override
    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    @Override
    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    @Override
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getLocalName();
            }
            case 2: {
                return ((Attribute)this.node).getLocalName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    @Override
    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    @Override
    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    @Override
    public NodeInfo getParent() {
        ParentNode p;
        if (this.parent == null && (p = this.node.getParent()) != null) {
            this.parent = this.makeWrapper((Node)p, this.docWrapper);
        }
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        int i;
        if (this.index != -1) {
            return this.index;
        }
        switch (this.nodeKind) {
            case 2: {
                Attribute att = (Attribute)this.node;
                Element p = (Element)att.getParent();
                if (p == null) {
                    return 0;
                }
                int i2 = p.getAttributeCount();
                while (--i2 >= 0) {
                    if (p.getAttribute(i2) != att) continue;
                    this.index = i2;
                    return i2;
                }
                throw new IllegalStateException("XOM node not linked to parent node");
            }
        }
        ParentNode p = this.node.getParent();
        int n = i = p == null ? 0 : p.indexOf(this.node);
        if (i == -1) {
            throw new IllegalStateException("XOM node not linked to parent node");
        }
        this.index = i;
        return this.index;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return new AncestorAxisIterator(this, false, nodeTest);
            }
            case 1: {
                return new AncestorAxisIterator(this, true, nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1 || ((Element)this.node).getAttributeCount() == 0) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeAxisIterator(this, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new ChildAxisIterator(this, true, true, nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new DescendantAxisIterator(this, false, false, nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantAxisIterator(this, true, false, nodeTest);
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                if (this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new DescendantAxisIterator(this, false, true, nodeTest);
            }
            case 7: {
                if (this.nodeKind == 2 || this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new ChildAxisIterator(this, false, true, nodeTest);
            }
            case 8: {
                if (this.nodeKind == 1) {
                    return NamespaceIterator.makeIterator(this, nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 9: {
                if (this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 10: {
                return new PrecedingAxisIterator(this, false, nodeTest);
            }
            case 11: {
                if (this.nodeKind == 2 || this.getParent() == null) {
                    return EmptyIterator.getInstance();
                }
                return new ChildAxisIterator(this, false, false, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new PrecedingAxisIterator(this, true, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        String uri;
        NamePool pool;
        String localName;
        Attribute att;
        if (this.nodeKind == 1 && (att = ((Element)this.node).getAttribute(localName = (pool = this.docWrapper.getNamePool()).getLocalName(fingerprint), uri = pool.getURI(fingerprint))) != null) {
            return att.getValue();
        }
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        if (this.docWrapper.node instanceof Document) {
            return this.docWrapper;
        }
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.getChildCount() > 0;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Navigator.copy(this, out, this.docWrapper.getNamePool(), whichNamespaces, copyAnnotations, locationId);
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            int size = elem.getNamespaceDeclarationCount();
            if (size == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] result = buffer == null || size > buffer.length ? new int[size] : buffer;
            NamePool pool = this.getNamePool();
            int i = 0;
            while (i < size) {
                String prefix = elem.getNamespacePrefix(i);
                String uri = elem.getNamespaceURI(prefix);
                result[i] = pool.allocateNamespaceCode(prefix, uri);
                ++i;
            }
            if (size < result.length) {
                result[size] = -1;
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.getNodeKind() == 2 && ((Attribute)this.node).getType() == Attribute.Type.ID;
    }

    @Override
    public boolean isIdref() {
        return this.getNodeKind() == 2 && (((Attribute)this.node).getType() == Attribute.Type.IDREF || ((Attribute)this.node).getType() == Attribute.Type.IDREFS);
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    public void delete() throws XPathException {
        if (this.parent != null) {
            if (this.nodeKind == 2) {
                ((Element)this.parent.node).removeAttribute((Attribute)this.node);
            } else {
                ((ParentNode)this.parent.node).removeChild(this.node);
            }
        }
    }

    private final class AncestorAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeSelf;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;

        public AncestorAxisIterator(NodeWrapper start, boolean includeSelf, NodeTest test) {
            this.start = start;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            if (!includeSelf) {
                this.current = start;
            }
            this.includeSelf = includeSelf;
            this.position = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            this.current = this.current == null ? this.start : this.current.getParent();
            return this.current;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new AncestorAxisIterator(this.start, this.includeSelf, this.nodeTest);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private final class AttributeAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private NodeInfo current;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        public AttributeAxisIterator(NodeWrapper start, NodeTest test) {
            this.start = start;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            this.position = 0;
            this.cursor = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            Element elem = (Element)this.start.node;
            if (this.cursor == elem.getAttributeCount()) {
                return null;
            }
            NodeWrapper curr = NodeWrapper.this.makeWrapper((Node)elem.getAttribute(this.cursor), NodeWrapper.this.docWrapper, this.start, this.cursor);
            ++this.cursor;
            return curr;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new AttributeAxisIterator(this.start, this.nodeTest);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private final class ChildAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private int ix;
        private boolean downwards;
        private boolean forwards;
        private NodeInfo current;
        private ParentNode par;
        private int cursor;
        private NodeTest nodeTest;
        private int position;

        private ChildAxisIterator(NodeWrapper start, boolean downwards, boolean forwards, NodeTest test) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            }
            this.nodeTest = test;
            this.position = 0;
            this.commonParent = downwards ? start : (NodeWrapper)start.getParent();
            this.par = (ParentNode)this.commonParent.node;
            if (downwards) {
                this.ix = forwards ? 0 : this.par.getChildCount();
            } else {
                this.ix = this.par.indexOf(start.node);
                if (forwards) {
                    ++this.ix;
                }
            }
            this.cursor = this.ix--;
            if (downwards || !forwards) {
                // empty if block
            }
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            Node nextChild;
            do {
                if (this.forwards) {
                    if (this.cursor == this.par.getChildCount()) {
                        return null;
                    }
                    nextChild = this.par.getChild(this.cursor++);
                    continue;
                }
                if (this.cursor == 0) {
                    return null;
                }
                nextChild = this.par.getChild(--this.cursor);
            } while (nextChild instanceof DocType);
            NodeWrapper curr = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix);
            this.ix += this.forwards ? 1 : -1;
            return curr;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new ChildAxisIterator(this.start, this.downwards, this.forwards, this.nodeTest);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private final class DescendantAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeSelf;
        private boolean following;
        private Node anchor;
        private Node currNode;
        private boolean moveToNextSibling;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;
        private String testLocalName;
        private String testURI;

        public DescendantAxisIterator(NodeWrapper start, boolean includeSelf, boolean following, NodeTest test) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.following = following;
            this.moveToNextSibling = following;
            if (!following) {
                this.anchor = start.node;
            }
            if (!includeSelf) {
                this.currNode = start.node;
            }
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            } else if (test instanceof NameTest) {
                NameTest nt = (NameTest)test;
                if (nt.getPrimitiveType() == 1) {
                    NamePool pool = NodeWrapper.this.getNamePool();
                    this.testLocalName = pool.getLocalName(nt.getFingerprint());
                    this.testURI = pool.getURI(nt.getFingerprint());
                }
            } else if (test instanceof NodeKindTest && test.getPrimitiveType() == 1) {
                this.testLocalName = "";
                this.testURI = null;
            }
            this.nodeTest = test;
            this.position = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            int i;
            if (this.currNode == null) {
                this.currNode = this.start.node;
                return this.start;
            }
            do {
                Node p;
                block5: {
                    i = 0;
                    p = this.currNode;
                    if (p.getChildCount() == 0 || this.moveToNextSibling) {
                        this.moveToNextSibling = false;
                        do {
                            if ((p = this.currNode.getParent()) == null) {
                                return null;
                            }
                            i = this.currNode.getParent().indexOf(this.currNode) + 1;
                            if (i < p.getChildCount()) break block5;
                            this.currNode = p;
                        } while (p != this.anchor);
                        return null;
                    }
                }
                this.currNode = p.getChild(i);
            } while (!this.conforms(this.currNode));
            return NodeWrapper.this.makeWrapper(this.currNode, NodeWrapper.this.docWrapper, null, i);
        }

        private boolean conforms(Node node) {
            if (this.testLocalName != null) {
                if (!(node instanceof Element)) {
                    return false;
                }
                if (this.testURI == null) {
                    return true;
                }
                Element elem = (Element)node;
                return this.testLocalName.equals(elem.getLocalName()) && this.testURI.equals(elem.getNamespaceURI());
            }
            return !(node instanceof DocType);
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new DescendantAxisIterator(this.start, this.includeSelf, this.following, this.nodeTest);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private final class PrecedingAxisIterator
    implements AxisIterator {
        private NodeWrapper start;
        private boolean includeAncestors;
        private Node currNode;
        private ParentNode nextAncestor;
        private NodeInfo current;
        private NodeTest nodeTest;
        private int position;
        private String testLocalName;
        private String testURI;

        public PrecedingAxisIterator(NodeWrapper start, boolean includeAncestors, NodeTest test) {
            this.start = start;
            this.includeAncestors = includeAncestors;
            this.currNode = start.node;
            ParentNode parentNode = this.nextAncestor = includeAncestors ? null : start.node.getParent();
            if (test == AnyNodeTest.getInstance()) {
                test = null;
            } else if (test instanceof NameTest) {
                NameTest nt = (NameTest)test;
                if (nt.getPrimitiveType() == 1) {
                    NamePool pool = NodeWrapper.this.getNamePool();
                    this.testLocalName = pool.getLocalName(nt.getFingerprint());
                    this.testURI = pool.getURI(nt.getFingerprint());
                }
            } else if (test instanceof NodeKindTest && test.getPrimitiveType() == 1) {
                this.testLocalName = "";
                this.testURI = null;
            }
            this.nodeTest = test;
            this.position = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.matches(curr)) {
            }
            if (curr != null) {
                ++this.position;
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            int i;
            while (true) {
                ParentNode p;
                if ((p = this.currNode.getParent()) == null) {
                    return null;
                }
                i = this.currNode.getParent().indexOf(this.currNode) - 1;
                if (i >= 0) {
                    int j;
                    p = p.getChild(i);
                    while ((j = p.getChildCount() - 1) >= 0) {
                        p = p.getChild(j);
                        i = j;
                    }
                } else if (p == this.nextAncestor) {
                    this.nextAncestor = this.nextAncestor.getParent();
                    this.currNode = p;
                    continue;
                }
                this.currNode = p;
                if (this.conforms(this.currNode)) break;
            }
            return NodeWrapper.this.makeWrapper(this.currNode, NodeWrapper.this.docWrapper, null, i);
        }

        private boolean conforms(Node node) {
            if (this.testLocalName != null) {
                if (!(node instanceof Element)) {
                    return false;
                }
                if (this.testURI == null) {
                    return true;
                }
                Element elem = (Element)node;
                return this.testLocalName.equals(elem.getLocalName()) && this.testURI.equals(elem.getNamespaceURI());
            }
            return !(node instanceof DocType);
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new PrecedingAxisIterator(this.start, this.includeAncestors, this.nodeTest);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

