/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SimpleExpression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.style.ExtensionInstruction;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.StringValue;

public class SQLQuery
extends ExtensionInstruction {
    Expression connection;
    Expression column;
    Expression table;
    Expression where;
    String rowTag;
    String colTag;
    boolean disable = false;

    @Override
    public void prepareAttributes() throws XPathException {
        String disableAtt;
        String dbCol = this.getAttributeValue("", "column");
        if (dbCol == null) {
            this.reportAbsence("column");
        }
        this.column = this.makeAttributeValueTemplate(dbCol);
        String dbTab = this.getAttributeValue("", "table");
        if (dbTab == null) {
            this.reportAbsence("table");
            dbTab = "saxon-dummy-table";
        }
        this.table = this.makeAttributeValueTemplate(dbTab);
        String dbWhere = this.getAttributeValue("", "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere);
        String connectAtt = this.getAttributeValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
        this.rowTag = this.getAttributeValue("", "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.getAttributeValue("", "column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((disableAtt = this.getAttributeValue("", "disable-output-escaping")) != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    @Override
    public void validate() throws XPathException {
        super.validate();
        this.column = this.typeCheck("column", this.column);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return new QueryInstruction(this.connection, this.column, this.table, this.where, this.rowTag, this.colTag, this.disable);
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int COLUMN = 1;
        public static final int TABLE = 2;
        public static final int WHERE = 3;
        String rowTag;
        String colTag;
        int options;

        public QueryInstruction(Expression connection, Expression column, Expression table, Expression where, String rowTag, String colTag, boolean disable) {
            Expression[] sub = new Expression[]{connection, column, table, where};
            this.setArguments(sub);
            this.rowTag = rowTag;
            this.colTag = colTag;
            this.options = disable ? 1 : 0;
        }

        @Override
        public int getImplementationMethod() {
            return 4;
        }

        @Override
        public String getExpressionType() {
            return "sql:query";
        }

        @Override
        public void process(XPathContext context) throws XPathException {
            boolean wasDEThrown;
            Controller controller = context.getController();
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                XPathException de = new XPathException("Value of connection expression is not a JDBC Connection");
                de.setXPathContext(context);
                throw de;
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            String dbCol = this.arguments[1].evaluateAsString(context).toString();
            String dbTab = this.arguments[2].evaluateAsString(context).toString();
            String dbWhere = this.arguments[3].evaluateAsString(context).toString();
            NamePool pool = controller.getNamePool();
            int rowCode = pool.allocate("", "", this.rowTag);
            int colCode = pool.allocate("", "", this.colTag);
            Statement ps = null;
            ResultSet rs = null;
            XPathException de = null;
            try {
                try {
                    StringBuffer statement = new StringBuffer();
                    statement.append("SELECT " + dbCol + " FROM " + dbTab);
                    if (!dbWhere.equals("")) {
                        statement.append(" WHERE " + dbWhere);
                    }
                    ps = connection.prepareStatement(statement.toString());
                    controller.setUserData(this, "sql:statement", ps);
                    rs = ps.executeQuery();
                    SequenceReceiver out = context.getReceiver();
                    String result = "";
                    int icol = rs.getMetaData().getColumnCount();
                    while (rs.next()) {
                        out.startElement(rowCode, 630, this.locationId, 0);
                        int col = 1;
                        while (col <= icol) {
                            result = rs.getString(col);
                            out.startElement(colCode, 630, this.locationId, 0);
                            if (result != null) {
                                out.characters(result, this.locationId, this.options);
                            }
                            out.endElement();
                            ++col;
                        }
                        out.endElement();
                    }
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage());
                    de.setXPathContext(context);
                    throw de;
                }
            }
            catch (Throwable throwable) {
                boolean wasDEThrown2;
                boolean bl = wasDEThrown2 = de != null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        de = new XPathException("(SQL) " + ex.getMessage());
                        de.setXPathContext(context);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ex) {
                        de = new XPathException("(SQL) " + ex.getMessage());
                        de.setXPathContext(context);
                    }
                }
                if (!wasDEThrown2 && de != null) {
                    throw de;
                }
                throw throwable;
            }
            boolean bl = wasDEThrown = de != null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage());
                    de.setXPathContext(context);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage());
                    de.setXPathContext(context);
                }
            }
            if (!wasDEThrown && de != null) {
                throw de;
            }
        }
    }
}

