/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SimpleExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.option.sql.SQLColumn;
import net2.sf.saxon.option.sql.SQLConnect;
import net2.sf.saxon.style.ExtensionInstruction;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.Whitespace;

public class SQLInsert
extends ExtensionInstruction {
    Expression connection;
    String table;

    @Override
    public void prepareAttributes() throws XPathException {
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo curr;
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr instanceof SQLColumn || curr.getNodeKind() == 3 && Whitespace.isWhite(curr.getStringValueCS())) continue;
            this.compileError("Only sql:column is allowed as a child of sql:insert", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        NodeInfo child;
        StringBuffer statement = new StringBuffer(120);
        statement.append("INSERT INTO " + this.table + " (");
        AxisIterator kids = this.iterateAxis((byte)3);
        int cols = 0;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            if (cols++ > 0) {
                statement.append(',');
            }
            String colname = ((SQLColumn)child).getColumnName();
            statement.append(colname);
        }
        statement.append(") VALUES (");
        int i = 0;
        while (i < cols) {
            if (i != 0) {
                statement.append(',');
            }
            statement.append('?');
            ++i;
        }
        statement.append(')');
        return new InsertInstruction(this.connection, statement.toString(), this.getColumnInstructions(exec));
    }

    public List getColumnInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            list.add(((SQLColumn)child).compile(exec));
        }
        return list;
    }

    private static class InsertInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int FIRST_COLUMN = 1;
        String statement;

        public InsertInstruction(Expression connection, String statement, List columnInstructions) {
            Expression[] sub = new Expression[columnInstructions.size() + 1];
            sub[0] = connection;
            int i = 0;
            while (i < columnInstructions.size()) {
                sub[i + 1] = (Expression)columnInstructions.get(i);
                ++i;
            }
            this.statement = statement;
            this.setArguments(sub);
        }

        @Override
        public int getImplementationMethod() {
            return 1;
        }

        @Override
        public String getExpressionType() {
            return "sql:insert";
        }

        @Override
        public Item evaluateItem(XPathContext context) throws XPathException {
            block16: {
                Item conn = this.arguments[0].evaluateItem(context);
                if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                    this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
                }
                Connection connection = (Connection)((ObjectValue)conn).getObject();
                PreparedStatement ps = null;
                try {
                    try {
                        ps = connection.prepareStatement(this.statement);
                        int i = 1;
                        int c = 1;
                        while (c < this.arguments.length) {
                            AtomicValue v = (AtomicValue)this.arguments[c].evaluateItem(context);
                            String val = v.getStringValue();
                            if (val.length() == 1) {
                                val = String.valueOf(val) + " ";
                            }
                            ps.setObject(i++, val);
                            ++c;
                        }
                        ps.executeUpdate();
                        if (!connection.getAutoCommit()) {
                            connection.commit();
                        }
                    }
                    catch (SQLException ex) {
                        this.dynamicError("SQL INSERT failed: " + ex.getMessage(), "SXSQ0004", context);
                        if (ps == null) break block16;
                        try {
                            ps.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            return null;
        }
    }
}

