/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SimpleExpression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.option.sql.SQLConnect;
import net2.sf.saxon.style.ExtensionInstruction;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.StringValue;

public class SQLDelete
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    @Override
    public void prepareAttributes() throws XPathException {
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
            this.table = "saxon-error-table";
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        String dbWhere = this.getAttributeList().getValue("", "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere);
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        super.validate();
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return new DeleteInstruction(this.connection, "DELETE FROM " + this.table, this.where);
    }

    private static class DeleteInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        String statement;

        public DeleteInstruction(Expression connection, String statement, Expression where) {
            Expression[] sub = new Expression[]{connection, where};
            this.statement = statement;
            this.setArguments(sub);
        }

        @Override
        public int getImplementationMethod() {
            return 1;
        }

        @Override
        public String getExpressionType() {
            return "sql:delete";
        }

        @Override
        public Item evaluateItem(XPathContext context) throws XPathException {
            block15: {
                Item conn = this.arguments[0].evaluateItem(context);
                if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                    this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
                }
                Connection connection = (Connection)((ObjectValue)conn).getObject();
                PreparedStatement ps = null;
                String dbWhere = this.arguments[1].evaluateAsString(context).toString();
                String localstmt = this.statement;
                if (!dbWhere.equals("")) {
                    localstmt = String.valueOf(localstmt) + " WHERE " + dbWhere;
                }
                try {
                    try {
                        ps = connection.prepareStatement(localstmt);
                        ps.executeUpdate();
                        if (!connection.getAutoCommit()) {
                            connection.commit();
                        }
                    }
                    catch (SQLException ex) {
                        this.dynamicError("SQL DELETE failed: " + ex.getMessage(), "SXSQ0004", context);
                        if (ps == null) break block15;
                        try {
                            ps.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            return null;
        }
    }
}

