/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.regex.Pattern;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SimpleExpression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.style.ExtensionInstruction;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.StringValue;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;
    private static Pattern namePattern = Pattern.compile("\"[^\"]+\"|[A-Za-z_][A-Za-z0-9_]*");

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String dbAtt = this.getAttributeValue("", "database");
        if (dbAtt == null) {
            this.reportAbsence("database");
            dbAtt = "";
        }
        this.database = this.makeAttributeValueTemplate(dbAtt);
        String dbDriver = this.getAttributeValue("", "driver");
        if (dbDriver == null) {
            if (dbAtt.length() > 9 && dbAtt.substring(0, 9).equals("jdbc:odbc")) {
                dbDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(dbDriver);
        String userAtt = this.getAttributeValue("", "user");
        this.user = userAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(userAtt);
        String pwdAtt = this.getAttributeValue("", "password");
        this.password = pwdAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(pwdAtt);
    }

    @Override
    public void validate() throws XPathException {
        super.validate();
        if (!this.getConfiguration().isLicensedFeature(8)) {
            throw new XPathException("sql:connect is not licensed in this Configuration");
        }
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password);
    }

    public static String quoteSqlName(String name) throws IllegalArgumentException {
        if (namePattern.matcher(name).matches()) {
            return name;
        }
        return "\"" + name + "\"";
    }

    private static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;

        public ConnectInstruction(Expression database, Expression driver, Expression user, Expression password) {
            Expression[] subs = new Expression[]{database, driver, user, password};
            this.setArguments(subs);
        }

        @Override
        public int getImplementationMethod() {
            return 1;
        }

        @Override
        public int computeCardinality() {
            return 16384;
        }

        @Override
        public String getExpressionType() {
            return "sql:connect";
        }

        @Override
        public Item evaluateItem(XPathContext context) throws XPathException {
            Connection connection = null;
            String dbString = this.arguments[0].evaluateAsString(context).toString();
            String dbDriverString = this.arguments[1].evaluateAsString(context).toString();
            String userString = this.arguments[2].evaluateAsString(context).toString();
            String pwdString = this.arguments[3].evaluateAsString(context).toString();
            try {
                Class.forName(dbDriverString);
                connection = DriverManager.getConnection(dbString, userString, pwdString);
            }
            catch (Exception ex) {
                this.dynamicError("JDBC Connection Failure: " + ex.getMessage(), "SXSQ0003", context);
            }
            return new ObjectValue(connection);
        }
    }
}

