/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.io.Serializable;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.option.sql.SQLConnect;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class SQLColumn
extends StyleElement {
    private String name;
    private Expression select;

    @Override
    public boolean isInstruction() {
        return false;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected boolean mayContainFallback() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String nameAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            String localName = atts.getLocalName(a);
            if (localName.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(atts.getNameCode(a));
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            this.name = "saxon-dummy-column";
        } else {
            this.name = SQLConnect.quoteSqlName(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"sql:column/select"), 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_ATOMIC, false, role, this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return this.select;
    }

    public String getColumnName() {
        return Navigator.getAttributeValue(this, "", "name");
    }
}

