/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.SQLException;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SimpleExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.style.ExtensionInstruction;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.ObjectValue;

public class SQLClose
extends ExtensionInstruction {
    Expression connection = null;

    @Override
    public void prepareAttributes() throws XPathException {
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return new CloseInstruction(this.connection);
    }

    private static class CloseInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;

        public CloseInstruction(Expression connect) {
            Expression[] sub = new Expression[]{connect};
            this.setArguments(sub);
        }

        @Override
        public int getImplementationMethod() {
            return 1;
        }

        @Override
        public String getExpressionType() {
            return "sql:close";
        }

        @Override
        public int computeCardinality() {
            return 24576;
        }

        @Override
        public Item evaluateItem(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL) Failed to close connection: " + ex.getMessage(), "SXSQ0002", context);
            }
            return null;
        }
    }
}

