/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.local;

import net2.sf.saxon.number.AbstractNumberer;

public class Numberer_nl
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static String[] dutchOrdinalUnits = new String[]{"", "Eenste", "Tweede", "Derde", "Vierde", "Vijfde", "Zesde", "Zevende", "Achtste", "Negende", "Tiende", "Elfde ", "Twaalfde", "Dertiende", "Veertiende", "Vijftiende", "Zestiende", "Zeventiende", "Achtiende", "Negentiende"};
    private static String[] dutchOrdinalTens = new String[]{"", "Tiende", "Twintigste", "Dertigste", "Veertigste", "Vijftigste", "Zestigste", "Zeventigste", "Tachtigste", "Negentigste"};
    private static String[] dutchUnits = new String[]{"", "Een", "Twee", "Drie", "Vier", "Vijf", "Zes", "Zeven", "Acht", "Negen", "Tien", "Elf", "Twaalf", "Dertien", "Veertien", "Vijftien", "Zestien", "Zeventien", "Achtien", "Negentien"};
    private static String[] dutchTens = new String[]{"", "Tien", "Twintig", "Dertig", "Veertig", "Vijftig", "Zestig", "Zeventig", "Tachtig", "Negentig"};
    private static String[] dutchMonths = new String[]{"Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli", "Augustus", "September", "Oktober", "November", "December"};
    private static String[] dutchDays = new String[]{"Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrijdag", "Zaterdag", "Zondag"};
    private static String[] dutchDayAbbreviations = new String[]{"Ma", "Di", "Woe", "Do", "Vrij", "Zat", "Zon"};
    private static int[] minUniqueDayLength = new int[]{1, 2, 1, 2, 1, 2, 2};

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 1000000000L) {
            s = "Miljardste";
        } else if (number == 1000000L) {
            s = "Miljoenste";
        } else if (number == 1000L) {
            s = "Duizendste";
        } else if (number == 100L) {
            s = "Honderste";
        } else if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            s = String.valueOf(this.toWords(number / 1000000000L)) + " Miljard" + (rem == 0L ? "" : String.valueOf(rem < 100L ? " en " : " ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            s = String.valueOf(this.toWords(number / 1000000L)) + " Miljoen" + (rem == 0L ? "" : String.valueOf(rem < 100L ? " en " : " ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000L) {
            long rem = number % 1000L;
            s = String.valueOf(number / 1000L == 1L ? "" : this.toWords(number / 1000L)) + "Duizend" + " " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 100L) {
            long rem = number % 100L;
            s = String.valueOf(number / 100L == 1L ? "" : this.toWords(number / 100L)) + "Honderd" + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else {
            int rem;
            s = number < 20L ? dutchOrdinalUnits[(int)number] : ((rem = (int)(number % 10L)) == 0 ? dutchOrdinalTens[(int)number / 10] : String.valueOf(dutchUnits[rem]) + (rem == 2 ? "\ufffdn" : "en") + dutchTens[(int)number / 10] + "ste");
        }
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String toWords(long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            return String.valueOf(this.toWords(number / 1000000000L)) + " Miljard" + (rem == 0L ? "" : String.valueOf(rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            return String.valueOf(this.toWords(number / 1000000L)) + " Miljoen" + (rem == 0L ? "" : String.valueOf(rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            return String.valueOf(number / 1000L == 1L ? "" : this.toWords(number / 1000L)) + "Duizend" + (rem == 0L ? "" : String.valueOf(rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return String.valueOf(number / 100L == 1L ? "" : this.toWords(number / 100L)) + "Honderd" + this.toWords(rem);
        }
        if (number < 20L) {
            return dutchUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        return String.valueOf(rem == 0 ? "" : dutchUnits[rem]) + (rem == 2 ? "\ufffdn" : "en") + dutchTens[(int)number / 10];
    }

    @Override
    public String toWords(long number, int wordCase) {
        String s = number == 0L ? "nul" : this.toWords(number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = dutchMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + ' ';
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = dutchDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = dutchDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }

    @Override
    public String halfDayName(int minutes, int minWidth, int maxWidth) {
        String s;
        if (minutes < 720) {
            switch (maxWidth) {
                case 1: {
                    s = "v";
                    break;
                }
                case 2: 
                case 3: {
                    s = "vm";
                    break;
                }
                default: {
                    s = "v.m.";
                    break;
                }
            }
        } else {
            switch (maxWidth) {
                case 1: {
                    s = "n";
                    break;
                }
                case 2: 
                case 3: {
                    s = "nm";
                    break;
                }
                default: {
                    s = "n.m.";
                }
            }
        }
        return s;
    }

    @Override
    public String getEraName(int year) {
        return year > 0 ? "n.C." : "v.C.";
    }
}

