/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.local;

import net2.sf.saxon.number.AbstractNumberer;

public class Numberer_fr
extends AbstractNumberer {
    private static final long serialVersionUID = -222104830008011842L;
    private static String[] frenchUnits = new String[]{"", "Un", "Deux", "Trois", "Quatre", "Cinq", "Six", "Sept", "Huit", "Neuf", "Dix", "Onze", "Douze", "Treize", "Quatorze", "Quinze", "Seize", "Dix-sept", "Dix-huit", "Dix-neuf"};
    private static String[] frenchTens = new String[]{"", "Dix", "Vingt", "Trente", "Quarante", "Cinquante", "Soixante", "Soixante", "Quatre-vingt", "Quatre-vingt"};
    private static String[] frenchOrdinalUnits = new String[]{"", "Premier", "Deuxi\ufffdme", "Troisi\ufffdme", "Quatri\ufffdme", "Cinqui\ufffdme", "Sixi\ufffdme", "Septi\ufffdme", "Huiti\ufffdme", "Neuvi\ufffdme", "Dixi\ufffdme", "Onzi\ufffdme", "Douzi\ufffdme", "Treizi\ufffdme", "Quatorzi\ufffdme", "Quinzi\ufffdme", "Seizi\ufffdme", "Dix-septi\ufffdme", "Dix-huiti\ufffdme", "Dix-neuvi\ufffdme"};
    private static String[] frenchOrdinalTens = new String[]{"", "Dixi\ufffdme", "Vingti\ufffdme", "Trenti\ufffdme", "Quaranti\ufffdme", "Cinquanti\ufffdme", "Soixanti\ufffdme", "Soixante", "Quatre-vingti\ufffdme", "Quatre-vingt"};
    private static String[] frenchDays = new String[]{"Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche"};
    private static String[] frenchMonths = new String[]{"Janvier", "F\ufffdvrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\ufffdt", "Septembre", "Octobre", "Novembre", "D\ufffdcembre"};

    @Override
    protected String ordinalSuffix(String ordinalParam, long number) {
        if (number != 1L) {
            return "e";
        }
        return "er";
    }

    @Override
    public String toWords(long number) {
        return this.toWords(number, true);
    }

    @Override
    public String toWords(long number, int wordCase) {
        String s = this.toWords(number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    private String toWords(long number, boolean terminal) {
        if (number == 0L) {
            return "Z\ufffdro";
        }
        if (number >= 1000000000000000000L) {
            long rem = number % 1000000000000000000L;
            long n = number / 1000000000000000000L;
            String s = n == 1L ? "Un" : this.toWords(n, true);
            return String.valueOf(s) + " quintillion" + (n > 1L ? "s" : "") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 1000000000000000L) {
            long rem = number % 1000000000000000L;
            long n = number / 1000000000000000L;
            String s = n == 1L ? "Un" : this.toWords(n, true);
            return String.valueOf(s) + " quatrillion" + (n > 1L ? "s" : "") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 1000000000000L) {
            long rem = number % 1000000000000L;
            long n = number / 1000000000000L;
            String s = n == 1L ? "Un" : this.toWords(n, true);
            return String.valueOf(s) + " trillion" + (n > 1L ? "s" : "") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            long n = number / 1000000000L;
            String s = n == 1L ? "Un" : this.toWords(n, true);
            return String.valueOf(s) + " milliard" + (n > 1L ? "s" : "") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            long n = number / 1000000L;
            String s = n == 1L ? "Un" : this.toWords(n, true);
            return String.valueOf(s) + " million" + (n > 1L ? "s" : "") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            long n = number / 1000L;
            String s = n == 1L ? "" : this.toWords(n, false);
            return String.valueOf(s) + (n == 1L ? "Mille" : " mille") + (rem == 0L ? "" : " " + this.toWords(rem, 1, terminal));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            long n = number / 100L;
            String s = n == 1L ? "" : this.toWords(n, false);
            return String.valueOf(s) + (n == 1L ? "Cent" : " cent") + (rem == 0L && n > 1L && terminal ? "s" : (rem != 0L ? " " + this.toWords(rem, 1, terminal) : ""));
        }
        if (number < 20L) {
            return frenchUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        int tens = (int)number / 10;
        if (tens == 7 || tens == 9) {
            rem += 10;
        }
        String link = rem == 1 || rem == 11 ? (tens == 8 || tens == 9 ? "-" : " et ") : "-";
        return String.valueOf(frenchTens[tens]) + (rem == 0 ? (tens == 8 && terminal ? "s" : "") : link) + (tens == 0 ? frenchUnits[rem] : frenchUnits[rem].toLowerCase());
    }

    private String toWords(long number, int wordCase, boolean terminal) {
        String s = this.toWords(number, terminal);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String ord;
        if (number < 20L) {
            ord = number == 0L ? "Z\ufffdroi\ufffdme" : frenchOrdinalUnits[(int)number];
        } else if (number < 100L) {
            long mod10 = number % 10L;
            long int10 = number / 10L;
            if (int10 == 7L || int10 == 9L) {
                --int10;
                mod10 += 10L;
            }
            if (mod10 == 0L) {
                ord = frenchOrdinalTens[(int)int10];
            } else {
                String link = mod10 == 1L || mod10 == 11L ? (int10 == 8L ? "-" : " et ") : "-";
                String prefix = this.toWords(int10 * 10L);
                if (int10 == 8L) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                String result = String.valueOf(prefix) + link;
                ord = String.valueOf(result) + (mod10 == 1L ? "uni\ufffdme" : this.toOrdinalWords("", mod10, 1));
            }
        } else {
            String suffix = "i\ufffdme";
            long mod100 = number % 100L;
            long int100 = number / 100L;
            if (int100 == 70L || int100 == 90L) {
                int100 -= 10L;
                mod100 += 100L;
            }
            String prefix = this.toWords(int100 * 100L, false);
            if (int100 % 10000L == 0L) {
                prefix = prefix.replaceFirst("Un ", "");
            }
            if ((prefix.endsWith("mille") || prefix.endsWith("Mille")) && mod100 == 0L) {
                prefix = prefix.substring(0, prefix.length() - 1);
            } else if (prefix.endsWith("illions") || prefix.endsWith("illiards")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            ord = String.valueOf(prefix) + (mod100 == 0L ? suffix : " " + (mod100 == 1L ? "uni\ufffdme" : this.toOrdinalWords("", mod100, 1)));
        }
        if (wordCase == 0) {
            return ord.toUpperCase();
        }
        if (wordCase == 1) {
            return ord.toLowerCase();
        }
        return ord;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = frenchMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + " ";
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = frenchDays[day - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = String.valueOf(name) + " ";
        }
        return name;
    }
}

