/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.jdom;

import java.util.Stack;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.option.jdom.DocumentWrapper;
import net2.sf.saxon.trans.XPathException;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMWriter
extends Builder {
    private Document document;
    private Stack ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(256);

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = new Document();
        this.document.setBaseURI(this.systemId);
        this.ancestors.push(this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.flush();
        String local = this.namePool.getLocalName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        String prefix = this.namePool.getPrefix(nameCode);
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        Element element = new Element(local, prefix, uri);
        if (this.ancestors.size() == 1) {
            this.document.setRootElement(element);
        } else {
            ((Element)this.ancestors.peek()).addContent((Content)element);
        }
        this.ancestors.push(element);
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
        String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
        Namespace ns = prefix.length() == 0 ? Namespace.getNamespace((String)uri) : Namespace.getNamespace((String)prefix, (String)uri);
        ((Element)this.ancestors.peek()).addNamespaceDeclaration(ns);
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String local = this.namePool.getLocalName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        String prefix = this.namePool.getPrefix(nameCode);
        Namespace ns = prefix.length() == 0 ? Namespace.getNamespace((String)uri) : Namespace.getNamespace((String)prefix, (String)uri);
        Attribute att = new Attribute(local, value.toString(), ns);
        ((Element)this.ancestors.peek()).getAttributes().add(att);
    }

    @Override
    public void startContent() throws XPathException {
        this.flush();
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        Object parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            Text text = new Text(this.textBuffer.toString());
            ((Element)this.ancestors.peek()).addContent((Content)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        ProcessingInstruction pi = new ProcessingInstruction(target, data.toString());
        ((Element)this.ancestors.peek()).addContent((Content)pi);
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        Comment comment = new Comment(chars.toString());
        ((Element)this.ancestors.peek()).addContent((Content)comment);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new DocumentWrapper(this.document, this.systemId, this.config);
    }
}

