/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.Transform;
import net2.sf.saxon.option.jdom.DocumentWrapper;
import net2.sf.saxon.trans.XPathException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOMTransform
extends Transform {
    @Override
    public List preprocess(List sources) throws XPathException {
        try {
            ArrayList<DocumentWrapper> jdomSources = new ArrayList<DocumentWrapper>(sources.size());
            int i = 0;
            while (i < sources.size()) {
                InputSource is;
                Source ss;
                Source src = (Source)sources.get(i);
                if (src instanceof SAXSource) {
                    ss = (SAXSource)sources.get(i);
                    is = ((SAXSource)ss).getInputSource();
                } else if (src instanceof StreamSource) {
                    ss = (StreamSource)src;
                    is = ((StreamSource)ss).getInputStream() != null ? new InputSource(((StreamSource)ss).getInputStream()) : (((StreamSource)ss).getReader() != null ? new InputSource(((StreamSource)ss).getReader()) : new InputSource(((StreamSource)ss).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                is.setSystemId(src.getSystemId());
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                DocumentWrapper jdom = new DocumentWrapper(doc, is.getSystemId(), this.config);
                jdomSources.add(jdom);
                ++i;
            }
            return jdomSources;
        }
        catch (JDOMException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOMTransform().doTransform(args, "JDOMTransform");
    }
}

