/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.jdom;

import java.io.Serializable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.expr.JPConverter;
import net2.sf.saxon.expr.PJConverter;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.ExternalObjectModel;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.TreeModel;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.om.VirtualNode;
import net2.sf.saxon.option.jdom.DocumentWrapper;
import net2.sf.saxon.option.jdom.JDOMWriter;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.SingletonItem;
import net2.sf.saxon.value.Value;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMObjectModel
extends TreeModel
implements ExternalObjectModel,
Serializable {
    private static JDOMObjectModel THE_INSTANCE = new JDOMObjectModel();

    public static JDOMObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getIdentifyingURI() {
        return "http://jdom.org/jaxp/xpath/jdom";
    }

    @Override
    public Builder makeBuilder() {
        return new JDOMWriter();
    }

    public boolean isRecognizedNode(Object object) {
        return object instanceof Document || object instanceof Element || object instanceof Attribute || object instanceof Text || object instanceof CDATA || object instanceof Comment || object instanceof ProcessingInstruction || object instanceof Namespace;
    }

    @Override
    public PJConverter getPJConverter(Class targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return JDOMObjectModel.this.convertXPathValueToObject(Value.asValue(value), targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass) {
        if (this.isRecognizedNodeClass(sourceClass)) {
            return new JPConverter(){

                @Override
                public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
                    return JDOMObjectModel.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    private boolean isRecognizedNodeClass(Class nodeClass) {
        return Document.class.isAssignableFrom(nodeClass) || Element.class.isAssignableFrom(nodeClass) || Attribute.class.isAssignableFrom(nodeClass) || Text.class.isAssignableFrom(nodeClass) || CDATA.class.isAssignableFrom(nodeClass) || Comment.class.isAssignableFrom(nodeClass) || ProcessingInstruction.class.isAssignableFrom(nodeClass) || Namespace.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        return false;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    private ValueRepresentation convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        if (this.isRecognizedNode(object)) {
            if (object instanceof Document) {
                return this.wrapDocument(object, ((Document)object).getBaseURI(), config);
            }
            Document root = this.getDocumentRoot(object);
            DocumentInfo docInfo = this.wrapDocument(root, root.getBaseURI(), config);
            return this.wrapNode(docInfo, object);
        }
        return null;
    }

    private Object convertXPathValueToObject(Value value, Object targetClass) {
        Object u;
        NodeInfo node;
        Class target = (Class)targetClass;
        if (value instanceof SingletonItem && (node = (NodeInfo)((SingletonItem)value).getItem()) instanceof VirtualNode && target.isAssignableFrom((u = ((VirtualNode)node).getRealNode()).getClass())) {
            return u;
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        Document documentNode = this.getDocumentRoot(node);
        return new DocumentWrapper(documentNode, baseURI, config);
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        return ((DocumentWrapper)document).wrap(node);
    }

    private Document getDocumentRoot(Object node) {
        while (!(node instanceof Document)) {
            if (node instanceof Element) {
                if (((Element)node).isRootElement()) {
                    return ((Element)node).getDocument();
                }
                node = ((Element)node).getParent();
                continue;
            }
            if (node instanceof Text) {
                node = ((Text)node).getParent();
                continue;
            }
            if (node instanceof Comment) {
                node = ((Comment)node).getParent();
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                node = ((ProcessingInstruction)node).getParent();
                continue;
            }
            if (node instanceof Attribute) {
                node = ((Attribute)node).getParent();
                continue;
            }
            if (node instanceof Document) {
                return (Document)node;
            }
            if (node instanceof Namespace) {
                throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
            }
            throw new IllegalStateException("Unknown JDOM node type " + node.getClass());
        }
        return (Document)node;
    }
}

