/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.option.dom4j;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SiblingCountingNode;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.om.VirtualNode;
import net2.sf.saxon.option.dom4j.DocumentWrapper;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Value;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object node, NodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper) {
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        NodeWrapper wrapper;
        if (node instanceof Document) {
            return docWrapper;
        }
        if (node instanceof Element) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = 1;
        } else if (node instanceof Attribute) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)2;
        } else if (node instanceof String || node instanceof Text || node instanceof CDATA) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)3;
        } else if (node instanceof Comment) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)8;
        } else if (node instanceof ProcessingInstruction) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)7;
        } else if (node instanceof Namespace) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)13;
        } else {
            throw new IllegalArgumentException("Bad node type in dom4j! " + node.getClass() + " instance " + node.toString());
        }
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    @Override
    public Object getRealNode() {
        return this.getUnderlyingNode();
    }

    @Override
    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((AtomicValue)this.atomize());
    }

    @Override
    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNode(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper ow = (NodeWrapper)other;
        return this.node.equals(ow.node);
    }

    @Override
    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    @Override
    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo n = this;
        if (this.getNodeKind() != 1) {
            n = n.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue(385);
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.docWrapper.baseURI;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        return Navigator.compareOrder(this, (SiblingCountingNode)other);
    }

    @Override
    public String getStringValue() {
        return NodeWrapper.getStringValue(this.node);
    }

    @Override
    public CharSequence getStringValueCS() {
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object node) {
        if (node instanceof Document) {
            return ((Document)node).getStringValue();
        }
        if (node instanceof Element) {
            return ((Element)node).getStringValue();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getValue();
        }
        if (node instanceof Text) {
            return ((Text)node).getText();
        }
        if (node instanceof CDATA) {
            return ((CDATA)node).getText();
        }
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof Comment) {
            return ((Comment)node).getText();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getStringValue();
        }
        if (node instanceof Namespace) {
            return ((Namespace)node).getURI();
        }
        return "";
    }

    @Override
    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    @Override
    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    @Override
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    @Override
    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    @Override
    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    @Override
    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof CDATA) {
                this.parent = this.makeWrapper(((CDATA)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
                }
                throw new IllegalStateException("Unknown DOM4J node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo n;
            AxisIterator iter;
            int ix = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    NodeWrapper parent = (NodeWrapper)this.getParent();
                    List children = parent.getNodeKind() == 9 ? ((Document)parent.node).content() : ((Element)parent.node).content();
                    ListIterator iterator = children.listIterator();
                    while (iterator.hasNext()) {
                        Object n2 = iterator.next();
                        if (n2 == this.node) {
                            this.index = ix;
                            return this.index;
                        }
                        ++ix;
                    }
                    throw new IllegalStateException("DOM4J node not linked to parent node");
                }
                case 2: {
                    iter = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    iter = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((n = (NodeInfo)iter.next()) != null) {
                if (n.isSameNodeInfo(this)) {
                    this.index = ix;
                    return this.index;
                }
                ++ix;
            }
            throw new IllegalStateException("DOM4J node not linked to parent node");
        }
        return this.index;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new NamespaceEnumeration(this), nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton(this.parent, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        if (this.nodeKind == 1) {
            Iterator list = ((Element)this.node).attributes().iterator();
            NamePool pool = this.docWrapper.getNamePool();
            while (list.hasNext()) {
                Attribute att = (Attribute)list.next();
                int nameCode = pool.allocate(att.getNamespacePrefix(), att.getNamespaceURI(), att.getName());
                if (fingerprint != (nameCode & 0xFFFFF)) continue;
                return att.getValue();
            }
        }
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    @Override
    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                List content = ((Element)this.node).content();
                int i = 0;
                while (i < content.size()) {
                    if (!(content.get(i) instanceof Namespace)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public long getDocumentNumber() {
        return this.getParent().getDocumentNumber();
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Navigator.copy(this, out, this.docWrapper.getNamePool(), whichNamespaces, copyAnnotations, locationId);
    }

    public void outputNamespaceNodes(Receiver out, boolean includeAncestors) throws XPathException {
        if (this.nodeKind == 1) {
            NodeWrapper wrapper;
            NamePool pool = this.docWrapper.getNamePool();
            AxisIterator enm = this.iterateAxis((byte)8);
            while ((wrapper = (NodeWrapper)enm.next()) != null && (includeAncestors || wrapper.getParent().isSameNodeInfo(this))) {
                Namespace ns = (Namespace)wrapper.node;
                int nscode = pool.allocateNamespaceCode(ns.getPrefix(), ns.getURI());
                out.namespace(nscode, 0);
            }
        }
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper ow = (NodeWrapper)other;
        if (this.node instanceof Namespace) {
            return this.getLocalPart().equals(ow.getLocalPart()) && this.getParent().isSameNodeInfo(ow.getParent());
        }
        return this.node.equals(ow.node);
    }

    @Override
    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            List namespaces = elem.declaredNamespaces();
            if (namespaces == null || namespaces.isEmpty()) {
                return EMPTY_NAMESPACE_LIST;
            }
            int count = namespaces.size();
            if (count == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] result = buffer == null || count > buffer.length ? new int[count] : buffer;
            NamePool pool = this.getNamePool();
            int n = 0;
            for (Namespace namespace : namespaces) {
                String prefix = namespace.getPrefix();
                String uri = namespace.getURI();
                result[n++] = pool.allocateNamespaceCode(prefix, uri);
            }
            if (count < result.length) {
                result[count] = -1;
            }
            return result;
        }
        return null;
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper start) {
            this.start = start;
            this.atts = ((Element)start.node).attributes().iterator();
        }

        @Override
        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        @Override
        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper start, boolean downwards, boolean forwards) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.commonParent = downwards ? start : (NodeWrapper)start.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).content().listIterator() : ((Element)this.commonParent.node).content().listIterator();
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                if (forwards) {
                    int i = 0;
                    while (i <= this.ix) {
                        this.children.next();
                        ++i;
                    }
                    ++this.ix;
                } else {
                    int i = 0;
                    while (i < this.ix) {
                        this.children.next();
                        ++i;
                    }
                    --this.ix;
                }
            }
        }

        @Override
        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object nextChild = this.children.next();
                    if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                        ++this.ix;
                        this.advance();
                        return;
                    }
                    if (nextChild instanceof Entity) {
                        throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                    }
                    this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object nextChild = this.children.previous();
                if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                    --this.ix;
                    this.advance();
                    return;
                }
                if (nextChild instanceof Entity) {
                    throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                }
                this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
            } else {
                this.current = null;
            }
        }

        @Override
        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class NamespaceEnumeration
    extends Navigator.BaseEnumeration {
        private HashMap<String, Namespace> nslist = new HashMap();
        private Iterator<String> prefixes;
        private int ix = 0;
        private NodeWrapper start;

        public NamespaceEnumeration(NodeWrapper start) {
            this.start = start;
            NodeWrapper curr = start;
            do {
                List addl;
                Element elem = (Element)curr.node;
                Namespace ns2 = elem.getNamespace();
                String prefix = ns2.getPrefix();
                String uri = ns2.getURI();
                if (!(prefix.length() == 0 && uri.length() == 0 || this.nslist.containsKey(prefix))) {
                    this.nslist.put(ns2.getPrefix(), ns2);
                }
                if ((addl = elem.additionalNamespaces()).isEmpty()) continue;
                for (Namespace ns2 : addl) {
                    if (this.nslist.containsKey(ns2.getPrefix())) continue;
                    this.nslist.put(ns2.getPrefix(), ns2);
                }
            } while ((curr = (NodeWrapper)curr.getParent()).getNodeKind() == 1);
            this.nslist.put("xml", Namespace.XML_NAMESPACE);
            this.prefixes = this.nslist.keySet().iterator();
        }

        @Override
        public void advance() {
            if (this.prefixes.hasNext()) {
                String prefix = this.prefixes.next();
                Namespace ns = this.nslist.get(prefix);
                this.current = NodeWrapper.this.makeWrapper(ns, NodeWrapper.this.docWrapper, this.start, this.ix++);
            } else {
                this.current = null;
            }
        }

        @Override
        public SequenceIterator getAnother() {
            return new NamespaceEnumeration(this.start);
        }
    }
}

