/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.TypeStrippedDocument;
import net2.sf.saxon.om.VirtualNode;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Value;

public class TypeStrippedNode
implements NodeInfo,
VirtualNode {
    protected NodeInfo node;
    protected TypeStrippedNode parent;
    protected TypeStrippedDocument docWrapper;

    protected TypeStrippedNode() {
    }

    protected TypeStrippedNode(NodeInfo node, TypeStrippedNode parent) {
        this.node = node;
        this.parent = parent;
    }

    protected TypeStrippedNode makeWrapper(NodeInfo node, TypeStrippedDocument docWrapper, TypeStrippedNode parent) {
        TypeStrippedNode wrapper = new TypeStrippedNode(node, parent);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    @Override
    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    @Override
    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    @Override
    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return this.atomize().iterate();
    }

    @Override
    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public int getTypeAnnotation() {
        if (this.getNodeKind() == 1) {
            return 630;
        }
        return 631;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof TypeStrippedNode) {
            return this.node.isSameNodeInfo(((TypeStrippedNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ 0x2C2C2C2C;
    }

    @Override
    public String getSystemId() {
        return this.node.getSystemId();
    }

    @Override
    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof TypeStrippedNode) {
            return this.node.compareOrder(((TypeStrippedNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    @Override
    public int getNameCode() {
        return this.node.getNameCode();
    }

    @Override
    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    @Override
    public NodeInfo getParent() {
        NodeInfo realParent;
        if (this.parent == null && (realParent = this.node.getParent()) != null) {
            this.parent = this.makeWrapper(realParent, this.docWrapper, null);
        }
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        return new WrappingIterator(this.node.iterateAxis(axisNumber), null);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        return this.node.getAttributeValue(fingerprint);
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    @Override
    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        this.node.copy(out, whichNamespaces, false, locationId);
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    @Override
    public boolean isId() {
        return this.node.isId();
    }

    @Override
    public boolean isIdref() {
        return this.node.isIdref();
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    private final class WrappingIterator
    implements AxisIterator {
        AxisIterator base;
        TypeStrippedNode parent;
        NodeInfo current;
        boolean atomizing = false;

        public WrappingIterator(AxisIterator base, TypeStrippedNode parent) {
            this.base = base;
            this.parent = parent;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            Item n = this.base.next();
            this.current = n instanceof NodeInfo && !this.atomizing ? TypeStrippedNode.this.makeWrapper((NodeInfo)n, TypeStrippedNode.this.docWrapper, this.parent) : (NodeInfo)n;
            return this.current;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.base.position();
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        @Override
        public SequenceIterator getAnother() {
            return new WrappingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

