/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import java.io.Serializable;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.tinytree.TinyBuilder;
import net2.sf.saxon.tinytree.TinyBuilderCondensed;
import net2.sf.saxon.tree.TreeBuilder;

public abstract class TreeModel
implements Serializable {
    public static final TreeModel TINY_TREE = new TinyTree();
    public static final TreeModel TINY_TREE_CONDENSED = new TinyTreeCondensed();
    public static final TreeModel LINKED_TREE = new LinkedTree();

    public abstract Builder makeBuilder();

    public int getSymbolicValue() {
        return -1;
    }

    public static TreeModel getTreeModel(int symbolicValue) {
        switch (symbolicValue) {
            case 1: {
                return TINY_TREE;
            }
            case 2: {
                return TINY_TREE_CONDENSED;
            }
            case 0: {
                return LINKED_TREE;
            }
        }
        throw new IllegalArgumentException("tree model " + symbolicValue);
    }

    public boolean isMutable() {
        return false;
    }

    private static class LinkedTree
    extends TreeModel {
        private LinkedTree() {
        }

        @Override
        public Builder makeBuilder() {
            return new TreeBuilder();
        }

        @Override
        public int getSymbolicValue() {
            return 0;
        }

        @Override
        public boolean isMutable() {
            return true;
        }
    }

    private static class TinyTree
    extends TreeModel {
        private TinyTree() {
        }

        @Override
        public Builder makeBuilder() {
            return new TinyBuilder();
        }

        @Override
        public int getSymbolicValue() {
            return 1;
        }
    }

    private static class TinyTreeCondensed
    extends TreeModel {
        private TinyTreeCondensed() {
        }

        @Override
        public Builder makeBuilder() {
            return new TinyBuilderCondensed();
        }

        @Override
        public int getSymbolicValue() {
            return 2;
        }
    }
}

