/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.Stripper;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SpaceStrippedDocument;
import net2.sf.saxon.om.VirtualNode;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Value;
import net2.sf.saxon.value.Whitespace;

public class SpaceStrippedNode
implements NodeInfo,
VirtualNode {
    protected NodeInfo node;
    protected SpaceStrippedNode parent;
    protected SpaceStrippedDocument docWrapper;

    protected SpaceStrippedNode() {
    }

    protected SpaceStrippedNode(NodeInfo node, SpaceStrippedNode parent) {
        this.node = node;
        this.parent = parent;
    }

    protected SpaceStrippedNode makeWrapper(NodeInfo node, SpaceStrippedDocument docWrapper, SpaceStrippedNode parent) {
        SpaceStrippedNode wrapper = new SpaceStrippedNode(node, parent);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    @Override
    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    @Override
    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    @Override
    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return this.atomize().iterate();
    }

    @Override
    public Value atomize() throws XPathException {
        Value baseVal = this.node.atomize();
        if (baseVal instanceof StringValue) {
            int primitiveType = ((StringValue)baseVal).getTypeLabel().getPrimitiveType();
            switch (primitiveType) {
                case 513: {
                    return new StringValue(this.getStringValueCS());
                }
                case 529: {
                    return new AnyURIValue(this.getStringValueCS());
                }
            }
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        return baseVal;
    }

    @Override
    public int getTypeAnnotation() {
        return this.node.getTypeAnnotation();
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof SpaceStrippedNode) {
            return this.node.isSameNodeInfo(((SpaceStrippedNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ 0x3C3C3C3C;
    }

    @Override
    public String getSystemId() {
        return this.node.getSystemId();
    }

    @Override
    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof SpaceStrippedNode) {
            return this.node.compareOrder(((SpaceStrippedNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                NodeInfo it;
                AxisIterator iter = this.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(3));
                FastStringBuffer sb = new FastStringBuffer(64);
                while ((it = (NodeInfo)iter.next()) != null) {
                    sb.append(it.getStringValueCS());
                }
                return sb.condense();
            }
        }
        return this.node.getStringValueCS();
    }

    @Override
    public int getNameCode() {
        return this.node.getNameCode();
    }

    @Override
    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    @Override
    public NodeInfo getParent() {
        NodeInfo realParent;
        if (this.parent == null && (realParent = this.node.getParent()) != null) {
            this.parent = this.makeWrapper(realParent, this.docWrapper, null);
        }
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 2: 
            case 8: {
                return new WrappingIterator(this.node.iterateAxis(axisNumber), this);
            }
            case 3: {
                return new StrippingIterator(this.node.iterateAxis(axisNumber), this);
            }
            case 7: 
            case 11: {
                SpaceStrippedNode parent = (SpaceStrippedNode)this.getParent();
                if (parent == null) {
                    return EmptyIterator.getInstance();
                }
                return new StrippingIterator(this.node.iterateAxis(axisNumber), parent);
            }
        }
        return new StrippingIterator(this.node.iterateAxis(axisNumber), null);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        return this.node.getAttributeValue(fingerprint);
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    @Override
    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Stripper stripper = this.docWrapper.getStripper().getAnother();
        stripper.setUnderlyingReceiver(out);
        this.node.copy(stripper, whichNamespaces, copyAnnotations, locationId);
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    private final class StrippingIterator
    implements AxisIterator {
        AxisIterator base;
        SpaceStrippedNode parent;
        NodeInfo currentVirtualNode;
        int position;

        public StrippingIterator(AxisIterator base, SpaceStrippedNode parent) {
            this.base = base;
            this.parent = parent;
            this.position = 0;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            NodeInfo nextRealNode;
            do {
                if ((nextRealNode = (NodeInfo)this.base.next()) != null) continue;
                return null;
            } while (!this.isPreserved(nextRealNode));
            this.currentVirtualNode = SpaceStrippedNode.this.makeWrapper(nextRealNode, SpaceStrippedNode.this.docWrapper, this.parent);
            ++this.position;
            return this.currentVirtualNode;
        }

        private boolean isPreserved(NodeInfo nextRealNode) {
            NodeInfo actualParent;
            if (nextRealNode.getNodeKind() != 3) {
                return true;
            }
            if (!Whitespace.isWhite(nextRealNode.getStringValueCS())) {
                return true;
            }
            NodeInfo nodeInfo = actualParent = this.parent == null ? nextRealNode.getParent() : this.parent.node;
            if (SpaceStrippedNode.this.docWrapper.containsPreserveSpace()) {
                NodeInfo p = actualParent;
                while (p.getNodeKind() == 1) {
                    String val = p.getAttributeValue(386);
                    if (val != null) {
                        if ("preserve".equals(val)) {
                            return true;
                        }
                        if ("default".equals(val)) break;
                    }
                    p = p.getParent();
                }
            }
            try {
                return SpaceStrippedNode.this.docWrapper.getStripper().isSpacePreserving(actualParent) == 1;
            }
            catch (XPathException e) {
                return true;
            }
        }

        @Override
        public Item current() {
            return this.currentVirtualNode;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.currentVirtualNode.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.currentVirtualNode.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.currentVirtualNode.getStringValue();
        }

        @Override
        public SequenceIterator getAnother() {
            return new StrippingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }

    private final class WrappingIterator
    implements AxisIterator {
        AxisIterator base;
        SpaceStrippedNode parent;
        NodeInfo current;
        boolean atomizing = false;

        public WrappingIterator(AxisIterator base, SpaceStrippedNode parent) {
            this.base = base;
            this.parent = parent;
        }

        @Override
        public boolean moveNext() {
            return this.next() != null;
        }

        @Override
        public Item next() {
            Item n = this.base.next();
            this.current = n instanceof NodeInfo && !this.atomizing ? SpaceStrippedNode.this.makeWrapper((NodeInfo)n, SpaceStrippedNode.this.docWrapper, this.parent) : (NodeInfo)n;
            return this.current;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.base.position();
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        @Override
        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        @Override
        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        @Override
        public SequenceIterator getAnother() {
            return new WrappingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

