/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.ReversibleIterator;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.UnfailingIterator;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SingletonItem;
import net2.sf.saxon.value.Value;

public class SingleNodeIterator
implements AxisIterator,
UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private NodeInfo item;
    private int position = 0;

    private SingleNodeIterator(NodeInfo value) {
        this.item = value;
    }

    public static AxisIterator makeIterator(NodeInfo item) {
        if (item == null) {
            return EmptyIterator.getInstance();
        }
        return new SingleNodeIterator(item);
    }

    @Override
    public boolean hasNext() {
        return this.position == 0;
    }

    @Override
    public boolean moveNext() {
        return this.next() != null;
    }

    @Override
    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    @Override
    public Item current() {
        if (this.position == 1) {
            return this.item;
        }
        return null;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int getLastPosition() {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        if (this.position == 1) {
            return this.item.iterateAxis(axis, test);
        }
        throw new NullPointerException();
    }

    @Override
    public Value atomize() throws XPathException {
        if (this.position == 1) {
            return this.item.atomize();
        }
        throw new NullPointerException();
    }

    @Override
    public CharSequence getStringValue() {
        if (this.position == 1) {
            return this.item.getStringValueCS();
        }
        throw new NullPointerException();
    }

    @Override
    public SequenceIterator getAnother() {
        return new SingleNodeIterator(this.item);
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new SingleNodeIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        return new SingletonItem(this.item);
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

